/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.memory;

import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.table.TableCellRenderer;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsDiff;
import org.netbeans.lib.profiler.results.memory.AllocMemoryResultsSnapshot;
import org.netbeans.lib.profiler.ui.components.table.ClassNameTableCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.CustomBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.DiffBarCellRenderer;
import org.netbeans.lib.profiler.ui.components.table.LabelTableCellRenderer;
import org.netbeans.lib.profiler.ui.memory.MemoryResUserActionsHandler;
import org.netbeans.lib.profiler.ui.memory.SnapshotAllocResultsPanel;

public class DiffAllocResultsPanel
extends SnapshotAllocResultsPanel {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.netbeans.lib.profiler.ui.memory.Bundle");
    private static final String GO_SOURCE_POPUP_ITEM_NAME = messages.getString("AllocResultsPanel_GoSourcePopupItemName");
    private AllocMemoryResultsDiff diff;
    private JMenuItem popupShowSource;
    private JPopupMenu memoryResPopupMenu;

    public DiffAllocResultsPanel(AllocMemoryResultsSnapshot allocMemoryResultsSnapshot, MemoryResUserActionsHandler memoryResUserActionsHandler) {
        super(allocMemoryResultsSnapshot, memoryResUserActionsHandler);
        this.diff = (AllocMemoryResultsDiff)allocMemoryResultsSnapshot;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.popupShowSource) {
            this.performDefaultAction(-1);
        }
    }

    protected CustomBarCellRenderer getBarCellRenderer() {
        return new DiffBarCellRenderer(this.diff.getMinObjectsSizePerClassDiff(), this.diff.getMaxObjectsSizePerClassDiff());
    }

    protected JPopupMenu getPopupMenu() {
        if (this.memoryResPopupMenu == null) {
            this.memoryResPopupMenu = new JPopupMenu();
        }
        return this.memoryResPopupMenu;
    }

    protected Object computeValueAt(int n, int n2) {
        int n3 = (Integer)this.filteredToFullIndexes.get(n);
        switch (n2) {
            case 0: {
                return this.sortedClassNames[n3];
            }
            case 1: {
                return new Long(this.totalAllocObjectsSize[n3]);
            }
            case 2: {
                return (this.totalAllocObjectsSize[n3] > 0L ? "+" : "") + this.intFormat.format(this.totalAllocObjectsSize[n3]) + " B";
            }
            case 3: {
                return (this.nTotalAllocObjects[n3] > 0 ? "+" : "") + this.intFormat.format(this.nTotalAllocObjects[n3]);
            }
        }
        return null;
    }

    protected void initColumnsData() {
        super.initColumnsData();
        ClassNameTableCellRenderer classNameTableCellRenderer = new ClassNameTableCellRenderer();
        LabelTableCellRenderer labelTableCellRenderer = new LabelTableCellRenderer(11);
        this.columnRenderers = new TableCellRenderer[]{classNameTableCellRenderer, null, labelTableCellRenderer, labelTableCellRenderer};
    }

    protected void initDataUponResultsFetch() {
        super.initDataUponResultsFetch();
        if (this.barRenderer != null) {
            this.barRenderer.setMinimum(this.diff.getMinObjectsSizePerClassDiff());
            this.barRenderer.setMaximum(this.diff.getMaxObjectsSizePerClassDiff());
        }
    }

    protected boolean passesValueFilter(int n) {
        return true;
    }

    protected void performDefaultAction(int n) {
        String string = null;
        int n2 = this.resTable.getSelectedRow();
        if (n2 != -1) {
            string = this.resTable.getValueAt(n2, 0).toString().replaceAll("\\[\\]", "");
        }
        if (string != null) {
            this.actionsHandler.showSourceForMethod(string, null, null);
        }
    }

    protected boolean truncateZeroItems() {
        return false;
    }
}

