/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import org.netbeans.lib.profiler.ui.UIUtils;

public class SnippetPanel
extends JPanel
implements MouseListener,
KeyListener,
FocusListener {
    private static Color lineColor;
    private static Color backgroundColor;
    private static Color focusedBackgroundColor;
    private static Color textColor;
    private JComponent content;
    private String snippetName;
    private Title title;
    private boolean collapsed = false;

    public SnippetPanel(String string, JComponent jComponent) {
        this.snippetName = string;
        this.content = jComponent;
        this.setLayout(new BorderLayout());
        this.title = new Title(string){

            public AccessibleContext getAccessibleContext() {
                return SnippetPanel.this.getAccessibleContext();
            }
        };
        this.title.setFocusable(true);
        this.title.addKeyListener(this);
        this.title.addMouseListener(this);
        this.title.addFocusListener(this);
        this.title.setToolTipText(jComponent.getToolTipText());
        jComponent.setToolTipText(null);
        this.add((Component)this.title, "North");
        this.add((Component)jComponent, "Center");
        this.getAccessibleContext().setAccessibleName(string);
    }

    private static void initColors() {
        boolean bl;
        Color color = UIUtils.getProfilerResultsBackground();
        int n = color.getRed();
        int n2 = color.getGreen();
        int n3 = color.getBlue();
        boolean bl2 = bl = n < 41 || n2 < 32 || n3 < 25;
        if (bl) {
            lineColor = UIUtils.getSafeColor(n + 41, n2 + 32, n3 + 8);
            backgroundColor = UIUtils.getSafeColor(n + 7, n2 + 7, n3 + 7);
            focusedBackgroundColor = UIUtils.getSafeColor(n + 25, n2 + 25, n3 + 25);
        } else {
            lineColor = UIUtils.getSafeColor(n - 41, n2 - 32, n3 - 8);
            backgroundColor = UIUtils.getSafeColor(n - 7, n2 - 7, n3 - 7);
            focusedBackgroundColor = UIUtils.getSafeColor(n - 25, n2 - 25, n3 - 25);
        }
        textColor = UIManager.getColor("Button.foreground");
    }

    public void setCollapsed(boolean bl) {
        if (this.collapsed == bl) {
            return;
        }
        this.collapsed = bl;
        if (bl) {
            this.title.collapse();
        } else {
            this.title.expand();
        }
        this.content.setVisible(!bl);
        this.revalidate();
    }

    public boolean isCollapsed() {
        return this.collapsed;
    }

    public void setContent(JComponent jComponent) {
        this.content = jComponent;
    }

    public JComponent getContent() {
        return this.content;
    }

    public void setSnippetName(String string) {
        this.snippetName = string;
    }

    public String getSnippetName() {
        return this.snippetName;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.title.repaint();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.title.repaint();
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 32) {
            this.setCollapsed(!this.isCollapsed());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.title.setCursor(Cursor.getPredefinedCursor(12));
        this.title.setRollOver(true);
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.title.setCursor(Cursor.getPredefinedCursor(0));
        this.title.setRollOver(false);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.setCollapsed(!this.collapsed);
        this.requestFocus();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void requestFocus() {
        if (this.title != null) {
            this.title.requestFocus();
        }
    }

    static {
        SnippetPanel.initColors();
    }

    private static class TitleUI
    extends ComponentUI {
        ImageIcon collapsedIcon = new ImageIcon(TitleUI.class.getResource("collapsedSnippet.png"));
        ImageIcon expandedIcon = new ImageIcon(TitleUI.class.getResource("expandedSnippet.png"));

        private TitleUI() {
        }

        public Dimension getPreferredSize(JComponent jComponent) {
            FontMetrics fontMetrics = jComponent.getGraphics().getFontMetrics(jComponent.getFont());
            return new Dimension(20 + fontMetrics.getStringBounds((String)((Title)jComponent).name, (Graphics)jComponent.getGraphics()).getBounds().width, fontMetrics.getHeight() + 4);
        }

        public void installUI(JComponent jComponent) {
            Font font = UIManager.getFont("Label.font");
            jComponent.setFont(font.deriveFont(1));
        }

        public void paint(Graphics graphics, JComponent jComponent) {
            ((Graphics2D)graphics).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Title title = (Title)jComponent;
            Font font = jComponent.getFont();
            if (title.collapsed) {
                graphics.setFont(font.deriveFont(0));
            } else {
                graphics.setFont(font);
            }
            graphics.setColor(lineColor);
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            graphics.drawLine(0, 0, jComponent.getWidth(), 0);
            if (title.collapsed) {
                if (title.rollOver || title.isFocusOwner()) {
                    graphics.setColor(focusedBackgroundColor);
                } else {
                    graphics.setColor(backgroundColor);
                }
            }
            graphics.drawLine(0, 1 + fontMetrics.getHeight() + 2, jComponent.getWidth(), 1 + fontMetrics.getHeight() + 2);
            if (title.rollOver || title.isFocusOwner()) {
                graphics.setColor(focusedBackgroundColor);
            } else {
                graphics.setColor(backgroundColor);
            }
            graphics.fillRect(0, 1, jComponent.getWidth(), fontMetrics.getHeight() + 2);
            graphics.setColor(textColor);
            graphics.drawString(title.name, 20, fontMetrics.getHeight() - 1);
            int n = 5;
            int n2 = 5;
            ImageIcon imageIcon = title.collapsed ? this.collapsedIcon : this.expandedIcon;
            imageIcon.paintIcon(jComponent, graphics, n, n2);
        }
    }

    private static class Title
    extends JComponent
    implements Accessible {
        String name;
        private boolean collapsed;
        private boolean rollOver;

        private Title(String string) {
            this.name = string;
            this.setUI(new TitleUI());
        }

        public void setRollOver(boolean bl) {
            if (bl == this.rollOver) {
                return;
            }
            this.rollOver = bl;
            this.repaint();
        }

        public void collapse() {
            this.collapsed = true;
            this.repaint();
        }

        public void expand() {
            this.collapsed = false;
            this.repaint();
        }
    }

    public static class Padding
    extends JPanel {
        public Padding() {
            this.setBackground(UIUtils.getProfilerResultsBackground());
            this.setOpaque(true);
        }

        protected void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            graphics.setColor(lineColor);
            graphics.drawLine(0, 0, this.getWidth(), 0);
        }
    }
}

