/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.MenuComponent;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.FilteredImageSource;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;

public class JTitledPanel
extends JPanel {
    private static final ImageIcon closePanelIcon = new ImageIcon(JTitledPanel.class.getResource("/org/netbeans/lib/profiler/ui/resources/closePanel.png"));
    private static final ImageIcon maximizePanelIcon = new ImageIcon(JTitledPanel.class.getResource("/org/netbeans/lib/profiler/ui/resources/maximizePanel.png"));
    private static final ImageIcon restorePanelIcon = new ImageIcon(JTitledPanel.class.getResource("/org/netbeans/lib/profiler/ui/resources/restorePanel.png"));
    private static final ImageIcon minimizePanelIcon = new ImageIcon(JTitledPanel.class.getResource("/org/netbeans/lib/profiler/ui/resources/minimizePanel.png"));
    public static final int STATE_CLOSED = 1000;
    public static final int STATE_RESTORED = 1001;
    public static final int STATE_MAXIMIZED = 1002;
    public static final int STATE_MINIMIZED = 1003;
    private AbstractButton presenter;
    private Icon icon;
    private JButton closePanelButton;
    private JButton maximizePanelButton;
    private JButton minimizePanelButton;
    private JButton restorePanelButton;
    private JPanel contentPanel;
    private JPanel titlePanel;
    private String title;
    private Vector actionListeners = new Vector();
    private boolean showButtons;
    private int state;

    public JTitledPanel(String string) {
        this(string, null);
    }

    public JTitledPanel(String string, Icon icon) {
        this(string, icon, false);
    }

    public JTitledPanel(String string, Icon icon, boolean bl) {
        this.title = string;
        this.icon = icon;
        this.showButtons = bl;
        this.initComponents();
        this.restore();
    }

    public void setButtonsEnabled(boolean bl) {
        this.closePanelButton.setEnabled(bl);
        this.maximizePanelButton.setEnabled(bl);
        this.restorePanelButton.setEnabled(bl);
        this.minimizePanelButton.setEnabled(bl);
    }

    public boolean isClosed() {
        return this.getState() == 1000;
    }

    public JPanel getContentPanel() {
        if (this.contentPanel == null) {
            this.contentPanel = new JPanel();
        }
        return this.contentPanel;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setLayout(LayoutManager layoutManager) {
        this.getContentPanel().setLayout(layoutManager);
    }

    public LayoutManager getLayout() {
        return this.getContentPanel().getLayout();
    }

    public boolean isMaximized() {
        return this.getState() == 1002;
    }

    public boolean isMinimized() {
        return this.getState() == 1003;
    }

    public Dimension getMinimumSize() {
        return new Dimension(0, this.titlePanel.getPreferredSize().height);
    }

    public AbstractButton getPresenter() {
        if (this.presenter == null) {
            this.presenter = new Presenter();
        }
        return this.presenter;
    }

    public boolean isRestored() {
        return this.getState() == 1001;
    }

    public int getState() {
        if (!this.isVisible()) {
            this.state = 1000;
        }
        if (this.isVisible() && this.state == 1000) {
            this.state = 1001;
        }
        return this.state;
    }

    public String getTitle() {
        return this.title;
    }

    public Component add(Component component) {
        return this.getContentPanel().add(component);
    }

    public Component add(Component component, int n) {
        return this.getContentPanel().add(component, n);
    }

    public void add(Component component, Object object) {
        this.getContentPanel().add(component, object);
    }

    public void add(Component component, Object object, int n) {
        this.getContentPanel().add(component, object, n);
    }

    public Component add(String string, Component component) {
        return this.getContentPanel().add(string, component);
    }

    public void add(PopupMenu popupMenu) {
        this.getContentPanel().add(popupMenu);
    }

    public void addActionListener(ActionListener actionListener) {
        if (!this.actionListeners.contains(actionListener)) {
            this.actionListeners.add(actionListener);
        }
    }

    public boolean areButtonsEnabled() {
        return this.closePanelButton.isEnabled();
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        this.setVisible(false);
        this.state = 1000;
        this.fireActionPerformed();
    }

    public void maximize() {
        if (this.isMaximized()) {
            return;
        }
        this.maximizePanelButton.setVisible(false);
        this.restorePanelButton.setVisible(true);
        this.minimizePanelButton.setVisible(true);
        this.contentPanel.setVisible(true);
        this.state = 1002;
        this.fireActionPerformed();
    }

    public void minimize() {
        if (this.isMinimized()) {
            return;
        }
        this.maximizePanelButton.setVisible(true);
        this.restorePanelButton.setVisible(true);
        this.minimizePanelButton.setVisible(false);
        this.contentPanel.setVisible(false);
        this.state = 1003;
        this.fireActionPerformed();
    }

    public void remove(Component component) {
        this.getContentPanel().remove(component);
    }

    public void remove(MenuComponent menuComponent) {
        this.getContentPanel().remove(menuComponent);
    }

    public void remove(int n) {
        this.getContentPanel().remove(n);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.remove(actionListener);
    }

    public void removeAll() {
        this.getContentPanel().removeAll();
    }

    public void restore() {
        if (this.isRestored()) {
            return;
        }
        this.maximizePanelButton.setVisible(true);
        this.restorePanelButton.setVisible(false);
        this.minimizePanelButton.setVisible(true);
        this.contentPanel.setVisible(true);
        this.state = 1001;
        this.fireActionPerformed();
    }

    private void fireActionPerformed() {
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            ((ActionListener)this.actionListeners.get(i)).actionPerformed(new ActionEvent(this, this.getState(), ""));
        }
    }

    private void initComponents() {
        DoubleClickListener doubleClickListener = new DoubleClickListener();
        this.titlePanel = new JPanel();
        this.titlePanel.addMouseListener(doubleClickListener);
        super.setLayout(new BorderLayout());
        JLabel jLabel = new JLabel(this.title){

            public Dimension getMinimumSize() {
                return new Dimension(0, super.getMinimumSize().height);
            }
        };
        if (this.icon != null) {
            jLabel.setIcon(this.icon);
        }
        jLabel.setForeground(UIManager.getColor("ToolTip.foreground"));
        jLabel.setFont(UIManager.getFont("ToolTip.font"));
        jLabel.setOpaque(false);
        jLabel.addMouseListener(doubleClickListener);
        this.closePanelButton = new ImageIconButton(closePanelIcon);
        this.closePanelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTitledPanel.this.close();
            }
        });
        this.maximizePanelButton = new ImageIconButton(maximizePanelIcon);
        this.maximizePanelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTitledPanel.this.maximize();
            }
        });
        this.restorePanelButton = new ImageIconButton(restorePanelIcon);
        this.restorePanelButton.setVisible(false);
        this.restorePanelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTitledPanel.this.restore();
            }
        });
        this.minimizePanelButton = new ImageIconButton(minimizePanelIcon);
        this.minimizePanelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JTitledPanel.this.minimize();
            }
        });
        JPanel jPanel = new JPanel(new FlowLayout(4, 0, 0));
        jPanel.setOpaque(false);
        jPanel.add(this.closePanelButton);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setOpaque(false);
        jPanel2.add((Component)jPanel, new GridBagConstraints());
        this.titlePanel.setLayout(new BorderLayout());
        this.titlePanel.add((Component)jLabel, "West");
        if (this.showButtons) {
            this.titlePanel.add((Component)jPanel2, "East");
        }
        this.titlePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(UIManager.getLookAndFeel().getID().equals("Metal") ? UIManager.getColor("Button.darkShadow") : UIManager.getColor("Button.shadow")), BorderFactory.createEmptyBorder(2, 5, 2, 2)));
        this.titlePanel.setOpaque(true);
        this.titlePanel.setBackground(new Color(245, 245, 245));
        super.add((Component)this.titlePanel, "North");
        super.add((Component)this.contentPanel, "Center");
    }

    private class Presenter
    extends JToggleButton {
        public Presenter() {
            if (JTitledPanel.this.getIcon() == null) {
                this.setText(JTitledPanel.this.getTitle());
                this.setToolTipText(JTitledPanel.this.getTitle());
            } else {
                this.setIcon(JTitledPanel.this.getIcon());
                this.setToolTipText(JTitledPanel.this.getTitle());
            }
            this.setSelected(JTitledPanel.this.isVisible());
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JTitledPanel.this.setVisible(Presenter.this.isSelected());
                }
            });
            JTitledPanel.this.addComponentListener(new ComponentAdapter(){

                public void componentShown(ComponentEvent componentEvent) {
                    Presenter.this.setSelected(true);
                }

                public void componentHidden(ComponentEvent componentEvent) {
                    Presenter.this.setSelected(false);
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("enabled".equals(propertyChangeEvent.getPropertyName())) {
                        JTitledPanel.this.setButtonsEnabled(Presenter.this.isEnabled());
                    }
                }
            });
        }
    }

    private class ImageIconButton
    extends JButton
    implements MouseListener {
        private Border emptyBorder = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        private Border loweredBorder = new ThinBevelBorder(1, Color.WHITE, Color.GRAY);
        private Border raisedBorder = new ThinBevelBorder(0, Color.WHITE, Color.GRAY);
        private boolean focused = false;
        private boolean pressed = false;

        public ImageIconButton(ImageIcon imageIcon) {
            GrayFilter grayFilter = new GrayFilter(true, 35);
            FilteredImageSource filteredImageSource = new FilteredImageSource(imageIcon.getImage().getSource(), grayFilter);
            ImageIcon imageIcon2 = new ImageIcon(Toolkit.getDefaultToolkit().createImage(filteredImageSource));
            GrayFilter grayFilter2 = new GrayFilter(true, 60);
            filteredImageSource = new FilteredImageSource(imageIcon.getImage().getSource(), grayFilter2);
            ImageIcon imageIcon3 = new ImageIcon(Toolkit.getDefaultToolkit().createImage(filteredImageSource));
            this.setIcon(imageIcon2);
            this.setRolloverIcon(imageIcon);
            this.setPressedIcon(imageIcon);
            this.setDisabledIcon(imageIcon3);
            this.setIconTextGap(0);
            this.setBorder(this.emptyBorder);
            this.setFocusable(false);
            this.setContentAreaFilled(false);
            this.setPreferredSize(new Dimension(imageIcon.getIconWidth() + 8, imageIcon.getIconHeight() + 8));
            this.addMouseListener(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.focused = true;
            if (this.pressed) {
                this.setBorder(this.loweredBorder);
            } else {
                this.setBorder(this.raisedBorder);
            }
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.focused = false;
            this.setBorder(this.emptyBorder);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.pressed = true;
            this.setBorder(this.loweredBorder);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.pressed = false;
            if (this.focused) {
                this.setBorder(this.raisedBorder);
            } else {
                this.setBorder(this.emptyBorder);
            }
        }
    }

    private class DoubleClickListener
    extends MouseAdapter {
        private DoubleClickListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getModifiers() == 16 && mouseEvent.getClickCount() == 2) {
                if (JTitledPanel.this.isMaximized()) {
                    JTitledPanel.this.restore();
                } else {
                    JTitledPanel.this.maximize();
                }
            }
        }
    }

    private static class ThinBevelBorder
    extends BevelBorder {
        public ThinBevelBorder(int n, Color color, Color color2) {
            super(n, color.brighter(), color, color2, color2.brighter());
        }

        public Insets getBorderInsets(Component component) {
            return new Insets(1, 1, 1, 1);
        }

        public Insets getBorderInsets(Component component, Insets insets) {
            insets.bottom = 1;
            insets.right = 1;
            insets.top = 1;
            insets.left = 1;
            return insets;
        }

        protected void paintLoweredBevel(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!component.isEnabled()) {
                return;
            }
            Color color = graphics.getColor();
            int n5 = n4;
            int n6 = n3;
            graphics.translate(n, n2);
            graphics.setColor(this.getShadowOuterColor(component));
            graphics.drawLine(0, 0, 0, n5 - 1);
            graphics.drawLine(1, 0, n6 - 1, 0);
            graphics.setColor(this.getHighlightInnerColor(component));
            graphics.drawLine(1, n5 - 1, n6 - 1, n5 - 1);
            graphics.drawLine(n6 - 1, 1, n6 - 1, n5 - 2);
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }

        protected void paintRaisedBevel(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!component.isEnabled()) {
                return;
            }
            Color color = graphics.getColor();
            int n5 = n4;
            int n6 = n3;
            graphics.translate(n, n2);
            graphics.setColor(this.getHighlightInnerColor(component));
            graphics.drawLine(0, 0, 0, n5 - 1);
            graphics.drawLine(1, 0, n6 - 1, 0);
            graphics.setColor(this.getShadowOuterColor(component));
            graphics.drawLine(0, n5 - 1, n6 - 1, n5 - 1);
            graphics.drawLine(n6 - 1, 0, n6 - 1, n5 - 2);
            graphics.translate(-n, -n2);
            graphics.setColor(color);
        }
    }
}

