/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.visualvm.host.impl;

import com.sun.tools.visualvm.host.impl.HostProperties;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.openide.DialogDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

class HostCustomizer
extends JPanel {
    private boolean internalChange = false;
    private static HostCustomizer instance;
    private JLabel hostnameLabel;
    private JTextField hostnameField;
    private JCheckBox displaynameCheckbox;
    private JTextField displaynameField;
    private JButton okButton;

    public static HostProperties defineHost() {
        HostCustomizer hc = HostCustomizer.getInstance();
        hc.setupDefineHost();
        DialogDescriptor dd = new DialogDescriptor((Object)hc, NbBundle.getMessage(HostCustomizer.class, (String)"Title_Add_Remote_Host"), true, new Object[]{hc.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)hc.okButton, 0, null, null);
        Dialog d = ProfilerDialogs.createDialog((DialogDescriptor)dd);
        d.pack();
        d.setVisible(true);
        if (dd.getValue() == hc.okButton) {
            return new HostProperties(hc.getHostName(), hc.getDisplayName());
        }
        return null;
    }

    private HostCustomizer() {
        this.initComponents();
        this.update();
    }

    private static HostCustomizer getInstance() {
        if (instance == null) {
            instance = new HostCustomizer();
        }
        return instance;
    }

    private String getHostName() {
        return this.hostnameField.getText().trim();
    }

    private String getDisplayName() {
        return this.displaynameField.getText().trim();
    }

    private void setupDefineHost() {
        this.hostnameField.setEnabled(true);
        this.displaynameCheckbox.setSelected(false);
        this.displaynameCheckbox.setEnabled(true);
        this.hostnameField.setText("");
        this.displaynameField.setText("");
    }

    private void update() {
        if (this.internalChange) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                String hostname = HostCustomizer.this.getHostName();
                if (!HostCustomizer.this.displaynameCheckbox.isSelected()) {
                    HostCustomizer.this.internalChange = true;
                    HostCustomizer.this.displaynameField.setText(hostname);
                    HostCustomizer.this.internalChange = false;
                }
                String displayname = HostCustomizer.this.getDisplayName();
                HostCustomizer.this.displaynameField.setEnabled(HostCustomizer.this.displaynameCheckbox.isSelected());
                HostCustomizer.this.okButton.setEnabled(hostname.length() > 0 && displayname.length() > 0);
            }
        });
    }

    private void initComponents() {
        this.setLayout(new GridBagLayout());
        this.hostnameLabel = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.hostnameLabel, (String)NbBundle.getMessage(HostCustomizer.class, (String)"LBL_Host_name"));
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(15, 10, 0, 0);
        this.add((Component)this.hostnameLabel, constraints);
        this.hostnameField = new JTextField();
        this.hostnameLabel.setLabelFor(this.hostnameField);
        this.hostnameField.setPreferredSize(new Dimension(250, this.hostnameField.getPreferredSize().height));
        this.hostnameField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                HostCustomizer.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                HostCustomizer.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                HostCustomizer.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 0;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(15, 5, 0, 10);
        this.add((Component)this.hostnameField, constraints);
        this.displaynameCheckbox = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.displaynameCheckbox, (String)NbBundle.getMessage(HostCustomizer.class, (String)"LBL_Display_name"));
        this.displaynameCheckbox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HostCustomizer.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        constraints.anchor = 13;
        constraints.insets = new Insets(8, 10, 0, 0);
        this.add((Component)this.displaynameCheckbox, constraints);
        this.displaynameField = new JTextField();
        this.displaynameField.setPreferredSize(new Dimension(250, this.displaynameField.getPreferredSize().height));
        this.displaynameField.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                HostCustomizer.this.update();
            }

            public void removeUpdate(DocumentEvent e) {
                HostCustomizer.this.update();
            }

            public void changedUpdate(DocumentEvent e) {
                HostCustomizer.this.update();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.fill = 2;
        constraints.anchor = 17;
        constraints.insets = new Insets(8, 5, 0, 10);
        this.add((Component)this.displaynameField, constraints);
        JPanel spacer = new JPanel(new BorderLayout(0, 0));
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 0;
        constraints.fill = 1;
        constraints.anchor = 18;
        constraints.insets = new Insets(0, 0, 15, 0);
        this.add((Component)spacer, constraints);
        this.okButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)NbBundle.getMessage(HostCustomizer.class, (String)"LBL_OK"));
        this.displaynameCheckbox.setBorder(this.hostnameLabel.getBorder());
    }
}

