require("libs.utils")

local win_msg_hook = nil
local game_start_hook = nil
local paint_hook = nil
local paint_font = dota.DrawUtils.GetInstance():CreateFont("", 14, 800, 0, 0, bit.bor(EFontFlags.FONTFLAG_DROPSHADOW, EFontFlags.FONTFLAG_OUTLINE))

local screenWidth = nil
local screenHeight = nil
local GamePausedStartTime = 0
local iAutoSendGamePausedTimeCount = 0

local bShowGamePausedTimer = App.GetConfig():GetBool("/utils/GamePausedTimer")
local bAutoSendGamePausedTime = App.GetConfig():GetBool("/utils/GamePausedBroadcast")

local say_method = App.GetConfig():GetBool("/utils/PrivateBroadcast") and "say_student" or "say"

function onWndProc(uMsg, wParam, lParam)
	if uMsg == WM_DotaConfig then
		if wParam == ConfigFlags.GamePausedTimer then
    		bShowGamePausedTimer = lParam > 0
        elseif wParam == ConfigFlags.GamePausedBroadcast then
            bAutoSendGamePausedTime = lParam > 0
        elseif wParam == ConfigFlags.PrivateBroadcast then
            say_method = (lParam > 0) and "say_student" or "say_team"
		end
	end
end

function OnPaint()
    if (GamePausedStartTime > 0) then
        local passed = math.floor((GetTickCount() - GamePausedStartTime)/1000)
        -- 暂停计时
        if (bShowGamePausedTimer == true) then
            local tstring = string.format("暂停计时：%02.0f:%02.0f", math.floor(math.fmod(passed,3600.0)/60.0), math.fmod(passed, 60.0))
            dota.DrawString(paint_font, screenWidth/2, screenHeight / 100 * 20, 0,255,0,255, true, tstring)
        end
        -- 暂停广播
        if (bAutoSendGamePausedTime == true) then
            if (GetTickCount() - iAutoSendGamePausedTimeCount) > 60000 then
                iAutoSendGamePausedTimeCount = GetTickCount()
                local dwMinute = math.floor(math.fmod(passed,3600)/60)
                dota.ExecuteCommand(string.format("%s \"游戏已暂停 \x12%d 分钟\x01。The game has paused for \x0C%d minutes\x01. (Dota2超级助手)\"",say_method,dwMinute,dwMinute))
            end
        end
    end
end

function OnMapLoadFinished()
    GamePausedStartTime = 0
end

function OnGamePaused(event)
    local message = event:GetInt("message",0)
    if (message == 34 or message == 38) then
        GamePausedStartTime = GetTickCount()
        iAutoSendGamePausedTimeCount = GamePausedStartTime
        if (bAutoSendGamePausedTime == true) then
            dota.ExecuteCommand(string.format("%s \"\x12暂停计时开始\x01：%s  (Dota2超级助手)\"",say_method,os.date("%Y年%m月%d日 \x12%X", os.time())))
        end
    elseif (message == 36) then
        GamePausedStartTime = 0
        iAutoSendGamePausedTimeCount = 0
        BringDotaWindowToTop()
    end
end

function Initialize()    
    screenWidth = dota.GetScreenWidth()
    screenHeight = dota.GetScreenHeight()
    paint_hook = dota.AddPaintHook(OnPaint)
    win_msg_hook = dota.AddWinMsgHook(onWndProc)
    game_start_hook = dota.AddMapLoadFinishedHook(OnMapLoadFinished)
    game_event_hook = dota.AddEventListener("dota_pause_event", OnGamePaused)

    log.Warning("[lua loaded] game_paused_timer.lua\n")
end