/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

//////////////////////////////////////////////////////////////////////////////
//
// Return false if parameter prop is invalid,
// i.e. prop is not defined or prop == null
//
function isValidProperty(prop)
{
    if (typeof(prop) == "undefined")
        return false;
    if (prop === null)
        return false;
    return true;
}

//////////////////////////////////////////////////////////////////////////////
//
// Throw exception if parameter inObj is invalid
//
function throwInvalid(inObj, inClassname)
{
    if (!isValidProperty(inObj))
    {
        throw "Invalid Object";
    }
    
    if (isValidProperty(inClassname))
    {
    	if(!eval('inObj instanceof ' + inClassname))
    	{
    		throw "Invalid Object Type";
    	}
    }
}

//////////////////////////////////////////////////////////////////////////////
//
// Calls callback function inProcessFct for each entry of Array inArray
//
function forEach(inArray, inProcessFct)
{
	throwInvalid(inArray, 'Array');
	throwInvalid(inProcessFct, 'Function');
	
	for (var i=0; i<inArray.length; i++)
	{
		inProcessFct(inArray[i]);
	}
}

//////////////////////////////////////////////////////////////////////////////
//
// Extend String object with new method
//
String.prototype.endsWith = function(/*[String]*/ inString)
{
	return this.indexOf(inString, this.length - inString.length) !== -1;
}

//////////////////////////////////////////////////////////////////////////////
//
// Create a copy of the event object
// Results in a vanilla object with the same properties as the event object
// up to the first level of properties (i.e. if one property contains an object
// then only the object classname is copied as a string)
//
var sEvObjProps = ['captures', 'currentTarget', 'target', 'eventPhase', 'type'];

function copyEventObject(inEventObj, inMaxLevel)
{
	if (!isValidProperty(inMaxLevel))
	{
		inMaxLevel = 1;
	}
	
	var ret = {};
	copyObject({out : ret, maxLevel : inMaxLevel, level : 0}, inEventObj, sEvObjProps);
	return ret;
}

//////////////////////////////////////////////////////////////////////////////
//
// Create a copy of the inObj
// Results in a vanilla object with the same properties as the inObj
// up to the first level of properties (i.e. if one property contains an object
// then only the object classname is copied as a string)
//
function copyObject(outObj, inObj, inXPropNames)
{
	outObj.level++;
	
	var props = [];
	
	if (isValidProperty(inXPropNames))
	{
		props = inXPropNames.slice();
	}
	
	var classRef = $.dictionary.getClass(inObj.reflect.name);

	if (classRef != null)
	{
		if (classRef.properties.length)
		{
			for (var p=0; p<classRef.properties.length; p++)
			{
				props.push(classRef.properties[p].name);
			}
		}
	}
	
	for (var p=0; p<props.length; p++)
	{
        var value = inObj[props[p]];
        
        if (typeof(value) == 'undefined')
        {
        	// nothing
        }
        else if (value == null)
        {
            outObj.out[props[p]] = null;
        }
        else if (typeof(value) == 'object')
        {
        	if (outObj.level < outObj.maxLevel)
        	{
        		copyObject(outObj, value);
        	}
        	else
        	{
	            outObj.out[props[p]] = '"' + value.toString() + '"';
	        }
        }
        else
        {
        	outObj.out[props[p]] = inObj[props[p]];
        }
	}
}
