/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

var externalObjectName = "PlugPlugExternalObject";
var lib = new ExternalObject( "lib:" + externalObjectName );

var eventObjects = {};
var eventCount = 0;

//////////////////////////////////////////////////////////////////////////////
//
// Dispatch ExtendScript events to CEP
// EventObjects ar copied (up to the first level of properties) for later access
//
function dispatchEvent(eventObj)
{
    eventObjects[eventCount] = copyEventObject(eventObj);

	//
	// send event to CEP
	//
    var event = new CSXSEvent();
    event.type = eventObj.type;
    event.data = eventCount;
    event.dispatch();

	// increase after dispatching event!
    eventCount++;
}

//////////////////////////////////////////////////////////////////////////////
//
// Clear stored copies of EventObjects
//
function clearEvents()
{
	eventObjects = {};
	eventCount = 0;
}

//////////////////////////////////////////////////////////////////////////////
//
// Return copy of EventObject with given index
//
function getEventObject(inIndex)
{
	var ret = null;
	
	if (inIndex < eventCount)
	{
		ret = eventObjects[inIndex];
	}
	
	return ret; 
}

//////////////////////////////////////////////////////////////////////////////
//
// Validate condition scriptlet
//
function validateCondition(inCondition, inEventObjIndex, inLog)
{
    var ret = { result : false, error : '' };
    var triggercond = inCondition;
    var index = NaN;
    
    try
    {
    	index = parseInt(inEventObjIndex);
    }
    catch(e)
    {
    	index = NaN;
    }
    
    if (triggercond.indexOf('${EVOBJ}$') >= 0 && !isNaN(index))
    {
        var replacement = 'getEventObject(' + index + ')';
        triggercond = triggercond.replace('${EVOBJ}$', replacement);
    }

    try
    {
        ret.result = eval(triggercond);
    }
    catch(e)
    {
        ret.result = false;
        ret.error = e.toString();
    }

    var retStr = '{';
    retStr += '"result" : ' + ret.result;
    retStr += ', ';
    retStr += '"error" : "' + ret.error + '"';
    
    if (isValidProperty(inLog) && inLog)
    {
    	retStr += ',';
    	retStr += '"log" : "' + logCondition(index, inCondition, ret.result) + '",';
    	retStr += '"eventObj" : ' + logEventObj(index);
    }
    
    retStr += '}';
    
    return retStr;
}
