/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

//////////////////////////////////////////////////////////////////////////////
//
// Increase the number the current user selected the given workflow
//
function incWorkflowAttempts(/*[String]*/ inWorkflowID)
{
	var num = getWorkflowAttempts(inWorkflowID);
	var support = new OnboardingSupport();
	var key = 'Onboarding_' + support.currentUserUID + '_' + inWorkflowID;

	try
	{
		app.localPreferences.setNumberValue(key, (num + 1));
	}
	catch(exc)
	{
	}
}

//////////////////////////////////////////////////////////////////////////////
//
// Return the number the current user selected the given workflow
//
function getWorkflowAttempts(/*[String]*/ inWorkflowID)
{
	var support = new OnboardingSupport();
	var key = 'Onboarding_' + support.currentUserUID + '_' + inWorkflowID;
	var num = 0;
	
	try
	{
		num = app.localPreferences.getNumberValue(key);
	}
	catch(exc)
	{
	}
	
	return num;
}

//////////////////////////////////////////////////////////////////////////////
//
// Log the action
//
function logAction(/*[Boolean]*/ inIsWorkflowAction,
				   /*[String]*/ inAction,
				   /*[String]*/ inWorkflowID,
				   /*[String]*/ inWorkflowName,
				   /*[String]*/ inWorkflowSessionID,
				   /*[Number]*/ inWorkflowAttempts,
				   /*[Number]*/ inStepNumber,
				   /*[Number]*/ inStepRetries,
				   /*[String]*/ inInteractivity,
				   /*[Number]*/ inWorkflowDuration,
				   /*[Number]*/ inStepDuration,
				   /*[Number]*/ inNumSteps)
{
	try
	{
		var support = new OnboardingSupport();
	
		if (inIsWorkflowAction)
		{
			support.onWorkflowAction(inAction, 
			                         inWorkflowID, 
			                         inWorkflowName,
									 inWorkflowSessionID,
			                         inWorkflowDuration, 
			                         inWorkflowAttempts,
									 inNumSteps);
		}
		else
		{
			var stepData = inStepNumber + ',' +
			               inStepRetries + ',' +
			               inStepDuration + ',' +
			               inWorkflowDuration + ',' +
			               inWorkflowAttempts + ',' +
						   inNumSteps;
								 
			support.onWorkflowStepAction(inAction, 
			                             inWorkflowID, 
			                             inWorkflowName,
										 inWorkflowSessionID,
										 inInteractivity,
			                             stepData);
		}
	}
	catch(exc)
	{
	}
}				   
