/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

var gDbgLog = null;
var kLogFilename_Debug = 'onboarding_dbg.log';

function DebugLog(/*[String]*/ inPath, /*[Boolean]*/ inActive)
{
	var path = inPath;
	var active = inActive;
	var data = '';
	
	this.log = function(/*[String]*/ inWhat)
	{
		if (active)
		{
			var entry = '';
			entry += Date().toString();
			entry += '\t';
			entry += inWhat;
			entry += '\n';
		
			store(entry);
		}
	}
	
	function store(/*[String]*/ inWhat)
	{
		var ret = false;		
		var logFilePath = path + kLogFilename_Debug;
		
		createFolder(path);
		
		data += inWhat;
		result = cep.fs.writeFile(logFilePath, data);
		
		return (isValidProperty(result) && result.err == cep.fs.NO_ERROR);
	}
	
	function createFolder(/*[String]*/ inPath)
	{
		var result = cep.fs.stat(inPath);
		
		if (isValidProperty(result) && !result.data.isDirectory())
		{
			cep.fs.makedir(inPath);
		}
	}
	
	(function()
	{
		cep.fs.deleteFile(inPath + kLogFilename_Debug);
	})();
}

DebugLog.get = function()
{
	if (!isValidProperty(gDbgLog))
	{
		var path = getPreferencesFolder() + 'logs/';
		gDbgLog = new DebugLog(path, __debuglog__);
	}
	
	return gDbgLog;
}
