/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

//////////////////////////////////////////////////////////////
//
// register ExtendScript event
//
function addEventListener(type, handler)
{
	var cs = new CSInterface();
	cs.addEventListener(type, handler);
	cs.evalScript('Application.addEventListener("' + type + '", dispatchEvent, true);');
}

//////////////////////////////////////////////////////////////
//
// unregister ExtendScript event
//
function removeEventListener(type, handler)
{
	var cs = new CSInterface();
	cs.removeEventListener(type, handler);
	cs.evalScript('Application.removeEventListener("' + type + '", dispatchEvent, true);');
}

//////////////////////////////////////////////////////////////////////////////
//
// Return false if parameter prop is invalid,
// i.e. prop is not defined or prop == null
//
function isValidProperty(prop)
{
    if (typeof(prop) == "undefined")
        return false;
    if (prop === null)
        return false;
    return true;
}

//////////////////////////////////////////////////////////////////////////////
//
// Throw exception if parameter inObj is invalid
//
function throwInvalid(inObj, inClassname)
{
    if (!isValidProperty(inObj))
    {
        throw "Invalid Object";
    }
    
    if (isValidProperty(inClassname))
    {
    	if(!eval('inObj instanceof ' + inClassname))
    	{
    		throw "Invalid Object Type";
    	}
    }
}

//////////////////////////////////////////////////////////////////////////////
//
// Write into debug log
//
function dbglog(/*[String]*/ inWhat)
{
	DebugLog.get().log(inWhat);
}

//////////////////////////////////////////////////////////////////////////////
//
// Write into debug log
//
function exclog(/*[Object]*/ inException)
{
	if (isValidProperty(inException))
	{
		var msg = inException.toString();
		
		if (isValidProperty(inException.stack))
		{
			msg += '\n' + inException.stack;
		}
		
		DebugLog.get().log("EXCEPTION: " + msg);
	}
}

//////////////////////////////////////////////////////////////////////////////
//
// Calls callback function inProcessFct for each entry of Array inArray
//
function forEach(inArray, inProcessFct)
{
	throwInvalid(inArray, 'Array');
	throwInvalid(inProcessFct, 'Function');
	
	for (var i=0; i<inArray.length; i++)
	{
		inProcessFct(inArray[i]);
	}
}

//////////////////////////////////////////////////////////////////////////////
//
// Return true if the file exists
//
function fileExists(/*[String]*/ inPath)
{
	var ret = false;
	var res = cep.fs.stat(inPath);
	
	return (isValidProperty(res) && res.data.isFile && res.err == cep.fs.NO_ERROR);
}

//////////////////////////////////////////////////////////////////////////////
//
// Get current platform
//
var PLATFORM_WIN = 'win';
var PLATFORM_MAC = 'mac';

function getPlatform()
{
	var ret = PLATFORM_WIN;
	
	var cs = new CSInterface();
	if (cs.getOSInformation().indexOf("Mac") >= 0)
	{
		ret = PLATFORM_MAC;
	}
	
	return ret;
}

//////////////////////////////////////////////////////////////////////////////
//
// Return the absolute path to the application folder
//
// On Mac it is the folder the application bundle is located
// On Win it is the folder the application executable is located
//
function getApplicationFolder()
{
	var ret = '';
	
	var cs = new CSInterface();
	var path = cs.getSystemPath(SystemPath.HOST_APPLICATION);
	var pos = -1;

	if (getPlatform() == PLATFORM_MAC)
	{
		pos = path.indexOf('/Contents/MacOS');
	
		if (pos >= 0)
		{
			pos = path.lastIndexOf('/', pos-1); 
		}			
	}
	else
	{
		pos = path.lastIndexOf('/');
	}

	if (pos >= 0)
	{
		ret = path.substring(0, pos+1);
	}
	
	return ret;
}

//////////////////////////////////////////////////////////////////////////////
//
// Get the preferences folder
// 
// On Mac it is inside the Library/Preference folder
// On Win it is in the appData folder
//
function getPreferencesFolder()
{
	var path = '';
	var cs = new CSInterface();
	var userData = cs.getSystemPath(SystemPath.USER_DATA);
	var version = cs.getHostEnvironment().appVersion;
	
	// need to shorten the version number to match the
	// existing folder name
	var versionParts = version.split('.');
	if (versionParts.length >= 2)
	{
		version = versionParts[0] + '.' + versionParts[1];
	}

	if (getPlatform() == PLATFORM_MAC)
	{
		var pos = userData.indexOf('/Application Support');
		if (pos >= 0)
		{
			path = userData.substring(0, pos+1);
			path += 'Preferences/Adobe/Audition/';
			path += version + '/';
		}
		else
		{
			path = '';
		}
	}
	else
	{
		path = userData + '/Adobe/Audition/';
		path += version + '/';
	}
	
	return path;
}

//////////////////////////////////////////////////////////////////////////////
//
// Generate UUID based on current time
//
function generateUUID()
{
	var base = new Date().getTime();
	var uuid = 'xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx'.replace(/[xy]/g, function(char)
	{
		var random = (base + Math.random() * 16) % 16 | 0;
		base = Math.floor(base / 16);
		return (char == 'x' ? random : (random & 0x3 | 0x8)).toString(16);
	});

	return uuid;
}

//////////////////////////////////////////////////////////////////////////////
//
// Global eval
//
var globalEval = (function()
{
	var isIndirectEvalGlobal = (function(original, Object)
	{
		try
		{
			// Does `Object` resolve to a local variable, or to a global, built-in `Object`,
			// reference to which we passed as a first argument?
			return (1,eval)('Object') === original;
		}
		catch(err)
		{
			exclog(err);
			return false;
		}
	})(Object, 123);

	if (isIndirectEvalGlobal)
	{

		// if indirect eval executes code globally, use it
		return function(expression) {
			return (1,eval)(expression);
		};
	}

	dbglog("'globalEval' not available");
})();

//////////////////////////////////////////////////////////////////////////////
//
// Return true if the remote resource exists
//
function requestRemoteContentExists(/*[String]*/ inURL, /*[Function] ([Boolean])*/ inResultHdl)
{
	var callback = inResultHdl;
	var request = new XMLHttpRequest();
	request.open("HEAD", inURL);

	request.addEventListener('load', function(inEvObj)
	{
		callback(request.status != 404);
	});

	request.addEventListener('error', function(inEvObj)
	{
		callback(false);
	});

	request.addEventListener('abort', function(inEvObj)
	{
		callback(false);
	});

	try
	{
		request.send();
	}
	catch(exc)
	{
		exclog(exc);
	}
}

//////////////////////////////////////////////////////////////////////////////
//
// Request remote content
//
function requestRemoteContent(/*[String]*/ inURL, /*[Function ([XMLHttpRequest])*/ inSuccessCallback, /*[Function ([XMLHttpRequest], [String])*/ inAbortCallback)
{
	var successCallback = inSuccessCallback;
	var abortCallback = inAbortCallback;
	var request = new XMLHttpRequest();

	request.open("GET", inURL + "?t=" + Date.now());

	request.addEventListener('load', function(inEvObj)
	{
		successCallback(request);
	});

	request.addEventListener('error', function(inEvObj)
	{
		abortCallback(request, 'error');
	});

	request.addEventListener('abort', function(inEvObj)
	{
		abortCallback(request, 'error');
	});

	try
	{
		request.send();
	}
	catch(exc)
	{
		exclog(exc);
	}

	return request.readyState;
}
