/***********************************************************************/
/*                                                                     */
/*                      ADOBE CONFIDENTIAL                             */
/*                   _ _ _ _ _ _ _ _ _ _ _ _ _                         */
/*                                                                     */
/*  Copyright 2016 Adobe Systems Incorporated                          */
/*  All Rights Reserved.                                               */
/*                                                                     */
/* NOTICE:  All information contained herein is, and remains           */
/* the property of Adobe Systems Incorporated and its suppliers,       */
/* if any.  The intellectual and technical concepts contained          */
/* herein are proprietary to Adobe Systems Incorporated and its        */
/* suppliers and are protected by all applicable intellectual property */
/* laws, including trade secret and copyright laws.                    */
/* Dissemination of this information or reproduction of this material  */
/* is strictly forbidden unless prior written permission is obtained   */
/* from Adobe Systems Incorporated.                                    */
/*                                                                     */
/***********************************************************************/

function Settings(/*[String]*/ inSettingsFilePath)
{
    var filepath = inSettingsFilePath;

    if (!isValidProperty(filepath))
    {
        filepath = getPreferencesFolder() + SETTINGS_FILENAME;
    }

    this.load = function()
    {
        var res = cep.fs.readFile(filepath);

        if (isValidProperty(res) && res.err == cep.fs.NO_ERROR)
        {
            try
            {
                var obj = JSON.parse(res.data);

                if (isValidProperty(obj))
                {
                    setSettings(obj);
                }
            }
            catch(exc)
            {
                exclog(exc);
                wf = null;
            }
        }
        else
        {
            dbglog("Can't load settings file (" + filepath + "): " + res.err);
        }
    }

    function setSettings(/*[Object]*/ inJSON)
    {
        if (isValidProperty(inJSON['UseRemoteWorkflowStorage']))
        {
            gUseRemoteWorkflowStorage = inJSON['UseRemoteWorkflowStorage'];
        }

        if (isValidProperty(inJSON['UseRemoteContentStorage']))
        {
            gUseRemoteContentStorage = inJSON['UseRemoteContentStorage'];
        }

        if (isValidProperty(inJSON['CacheRemoteContent']))
        {
            gCacheRemoteContent = inJSON['CacheRemoteContent'];
        }

        if (isValidProperty(inJSON['Remote_URL_Debug']))
        {
            REMOTE_URL_DEBUG = inJSON['Remote_URL_Debug'];
        }

        if (isValidProperty(inJSON['Remote_URL_Release']))
        {
            REMOTE_URL_RELEASE = inJSON['Remote_URL_Release'];
        }

        if (isValidProperty(inJSON['IgnoreContentBlackList']))
        {
            gIgnoreContentBlackList = inJSON['IgnoreContentBlackList'];
        }

        if (isValidProperty(inJSON['Debug']))
        {
            __debug__ = inJSON['Debug'];
        }

        if (isValidProperty(inJSON['DebugLog']))
        {
            __debuglog__ = inJSON['DebugLog'];
        }
    }
}
