require( "screens/style.lua" );

MyFont = {
  standardFont,
  28,
  YellowColor
};


WelcomeFont = {
  standardFont,
  22,
  YellowColor
};

WelcomeShadowFont = {
  standardFont,
  22,
  BlackColor
};

ButtonFont = {
  standardFont,
  20,
  ButtonTextColor
};

SmallFont = {
  standardFont,
  17,
  ButtonTextColor
};

MySmallFont = {
  standardFont,
  14,
  Color(0,0,0,255);
};

ChangeNameButtonGraphics = {
	"buttons/long_button_up.png",
	"buttons/long_button_down.png",
	"buttons/long_button_over.png"
};

CopyrightFont = {
  standardFont,
  12,
  Color(91,139,173,255);
};



MakeDialog
{
	
	Bitmap
	{ 
		name="backgroundimage",
		image="backgrounds/mainmenu.jpg",	
		
		
			
		StartScreen
		{
			x=0,y=000,
			w=800,h=600,
			name="animWindow",
			
			Text
			{
				font = CopyrightFont,
				name="copyright",
				label="copyright",
				x=5,
				y=5,
				w=245,
				h=15,
				flags = kHAlignCenter + kVAlignCenter
			},
			
			Bitmap
			{
				image="tm.png",	
				name="tm",
				x=700,
				y=18,
			},
			
			Text
			{
				font = WelcomeShadowFont,
				name="welcomeshadow",
				label="",
				x=131,
				y=544,
				w=366,
				h=556,
				flags = kHAlignCenter + kVAlignTop
			},
			
			
			Text
			{
				font = WelcomeFont,
				name="welcome",
				label="",
				x=130,
				y=543,
				w=365,
				h=555,
				flags = kHAlignCenter + kVAlignTop
			},
			


			TriclopsButton
			{
				x=450,
				y=545,
				Button
				{
					font = ButtonFont,
					graphics = NormalButtonGraphics,
					name="highscores",
					label="",
					type = kPush,
					scale = 0.61,
					Text
					{
						font = ButtonFont,
						name="highscoresbutton_high",
						label="highscoresbutton_high",
						x=0,
						y=10,
						w=kMax,
						h=100,
						flags = kHAlignCenter + kVAlignTop
					},
					Text
					{
						font = ButtonFont,
						name="highscoresbutton_scores",
						label="highscoresbutton_scores",
						x=0,
						y=24,
						w=kMax,
						h=100,
						flags = kHAlignCenter + kVAlignTop
					},
					
				},
			},
			
			TriclopsButton
			{
				x=570,
				y=545,
				Button
				{
					font = ButtonFont,
					graphics = NormalButtonGraphics,
					name="options",
					label="options",
					type = kPush,
					sound="",
					scale = 0.61
				},
			},
			
			TriclopsButton
			{
				x=690,
				y=545,
				Button
				{
					font = ButtonFont,
					graphics = NormalButtonGraphics,
					name="quit",
					label="quitbutton",
					type = kPush,
					scale = 0.61
				},
			},
			
			
			
			TriclopsButton
			{
				x=230,
				y=565,
				Button
				{
					font = SmallFont,
					graphics = ChangeNameButtonGraphics,
					name="changename",
					label="changename",
					type = kPush,
					scale = 0.8
					
				},
			},

			Bitmap
			{
				image="backgrounds/textfield.png",
				x=700,
				y=200,
				scale=0.5,
				name="leveleditfield",
				
				TextEdit
				{
					font = MySmallFont,
					name = "leveledit",
					label="1",
					x=10,y=0,w=kMax,h=kMax,
					length=12
					
				};
			};
			
			Button
			{
				font = MySmallFont,
				graphics = NormalButtonGraphics,
				name="gotostorylevelbutton",
				label="gotostorylevelbutton",
				type = kPush,
				scale = 0.5,
				x=700,
				y=230
			};
			
			Button
			{
				font = MySmallFont,
				graphics = NormalButtonGraphics,
				name="gotoshapelevelbutton",
				label="gotoshapelevelbutton",
				type = kPush,
				scale = 0.5,
				x=700,
				y=280
			};
			
			Button
			{
				font = MySmallFont,
				graphics = NormalButtonGraphics,
				name="watchmovie",
				label="watchmovie",
				type = kPush,
				scale = 0.5,
				x=50,
				y=230
			};
			
			Button
			{
				font = MySmallFont,
				graphics = NormalButtonGraphics,
				name="beatgame",
				label="beatgame",
				type = kPush,
				scale = 0.5,
				x=50,
				y=280
			};
		
			Button
			{
				font = MySmallFont,
				graphics = NormalButtonGraphics,
				name="shapedesign",
				label="shapedesignbutton",
				type = kPush,
				x=650,
				y=400
			},
			
			Button
			{
				font = MySmallFont,
				graphics = NormalButtonGraphics,
				name="leveldesign",
				label="leveldesignbutton",
				type = kPush,
				x=650,
				y=500
			};
		},
		
		
	}
}










