require( "screens/style.lua" )

MyFont = {
  standardFont,
  16,
  YellowColor
};

NoSaveFont = {
  standardFont,
  16,
  YellowColor
};

WarningFont = {
  standardFont,
  24,
  YellowColor
};

MyLargeFont = {
  standardFont,
  32,
  YellowColor
};



MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/small_dialog.jpg",	
		x=kCenter,
		y=kCenter,
		
		Text
		{
			font = WarningFont,
			name = "warning",
			x=25,y=25,w=234,h=50,
			flags = kHAlignCenter + kVAlignTop,
			label = "quitwarning"
		};
		
		Text
		{
			font = MyLargeFont,
			name = "mainmenuwarning",
			x=kCenter,y=25,w=kMax ,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "quitwarning"
		};
		
		Text
		{
			font = MyFont,
			name = "saveinfo",
			x=25,y=75,w=225 ,h=75,
			flags = kHAlignCenter + kVAlignTop,
			label = "saveinfo"

		};
		
		Text
		{
			font = NoSaveFont,
			name = "puzzlesaveinfo",
			x=25,y=90,w=225 ,h=75,
			flags = kHAlignCenter + kVAlignTop,
			label = "nopuzzlesave"

		};



		TriclopsButton
		{
			x=25,
			y=130,
			Button{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="quityes",
				label="yes",
				type = kPush,
				scale = 0.4,
				command=				
					function()
						PopModal();			
						PostMessage(CreateNamedMessage( 1007, "quityes" ));		
						
					end
			};
		},
		
		TriclopsButton
		{
			x=185,
			y=130,
			Button{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="quitno",
				close=true,
				label="no",
				type = kPush,
				scale = 0.4
			};
		}
	}
}



