require( "screens/style.lua" );



HeaderFont = {
  standardFont,
  48,
  YellowColor
};

HeaderShadowFont = {
  standardFont,
  48,
  BlackColor
};

MyFont = {
  standardFont,
  30,
  YellowColor
};

OptionsFont = {
  standardFont,
  18,
  YellowColor
};





MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/large_dialog.jpg",
		x=kLargeDialogX,
		y=kLargeDialogY,
		
		Text
		{
			font = HeaderShadowFont,
			name = "options",
			x=2,y=31,w=kMax,h=50,
			flags = kHAlignCenter + kVAlignTop,
			label = "options"
		};
		
		Text
		{
			font = HeaderFont,
			name = "options",
			x=0,y=30,w=kMax,h=50,
			flags = kHAlignCenter + kVAlignTop,
			label = "options"
		};
		
		
		Text
		{
			font = OptionsFont,
			name = "music",
			x=0,y=80,w=kMax,h=31,
			flags = kHAlignCenter + kVAlignTop,
			label = "soundlevel"
		};
		
		Slider
		{
			name="soundlevel",
			railimage = "buttons/sliderrail.png",
			sliderimage = "buttons/sliderknob.png",
			sliderrollimage = "buttons/sliderknobover.png",
			x = 60,
			y = 100,
		};
		
		
		Text
		{
			font = OptionsFont,
			name = "music",
			x=0,y=180,w=kMax,h=31,
			flags = kHAlignCenter + kVAlignTop,
			label = "musiclevel"
		};
		
		
		
		Slider
		{
			name="musiclevel",
			railimage = "buttons/sliderrail.png",
			sliderimage = "buttons/sliderknob.png",
			sliderrollimage = "buttons/sliderknobover.png",
			x = 60,
			y = 200,
		};

		Button{
			font = OptionsFont,
			graphics = RadioButtonGraphics,
			name="soundoff",
			type = kToggle,
			x=130,
			y=255,
			w=200,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg",
			Text
			{
				font = OptionsFont,
				name = "soundofflabel",
				x=50,
				y=25,
				w=200,
				h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label="muteall",
			};
			
		};
		
		
		Button{
			font = OptionsFont,
			graphics = RadioButtonGraphics,
			name="fullscreen",
			type = kToggle,
			x=130,
			y=300,
			w=200,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg",
			Text
			{
				font = OptionsFont,
				name = "fullscreenlabel",
				x=50,
				y=25,
				w=100,
				h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label="fullscreen",
			};
		};
		
		TriclopsButton
		{
			x=60,
			y=400,
			Button{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="credits",
				label="credits",
				type = kPush,
				scale = 0.61
				
			};
		},
		
		TriclopsButton
		{
			x=220,
			y=400,
			Button{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="ok",
				label="ok",
				type = kPush,
				scale = 0.61
			};
		}
	}
}



