require( "screens/style.lua" );


MyFont = {
  standardFont,
  12,
  Color(0,0,0,255);
};

LevelNumFont = {
  standardFont,
  16,
  Color(0,0,0,255);
};

MessageFont = {
  standardFont,
  70,
  Color(200,50,0,255);
};

WarningFont = {
  standardFont,
  24,
  Color(200,50,0,255);
};

LevelFont = {
  standardFont,
  24,
  Color(200,50,0,255);
};


ArrowUpButtonGraphics = {
	"buttons/arrowup_up.png",
	"buttons/arrowup_down.png",
	"buttons/arrowup_over.png"
};

ArrowDownButtonGraphics = {
	"buttons/arrowdown_up.png",
	"buttons/arrowdown_down.png",
	"buttons/arrowdown_over.png"
};

kArrowButtonScale = 0.4;



MakeDialog
{


		
	LevelDesignWindow
	{
		x=0,y=000,
		w=800,h=600,
		name="mainGameWindow",
		

		Text
		{
			font = WarningFont,
			name = "warning",
			x=200,y=100,w=400,h=400,
			flags = kHAlignCenter + kVAlignCenter,
			label = "Levels.dat is read-only. In order to edit levels, it must be writable"
		};
		
		Text
		{
			font = MyFont,
			name = "level",
			x=710,y=250,w=100,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "1 of 50"
		};

		

		Text
		{
			font = MyFont,
			name = "n8",
			x=710,y=325,w=100,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "level"
		};
		
		Text
		{
			font = MyFont,
			name = "urnrows1",
			x=565,y=250,w=100,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "1"
		};

		

		Text
		{
			font = MyFont,
			name = "urnrowslabel1",
			x=565,y=325,w=100,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "urn<br>rows<br>1"
		};
		
		Text
		{
			font = MyFont,
			name = "urnrows2",
			x=595,y=250,w=100,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "2"
		};

		

		Text
		{
			font = MyFont,
			name = "urnrowslabel2",
			x=595,y=325,w=100,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "urn<br>rows<br>2"
		};
		
		Text
		{
			font = MyFont,
			name = "urnrows3",
			x=625,y=250,w=100,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "3"
		};

		

		Text
		{
			font = MyFont,
			name = "urnrowslabel3",
			x=625,y=325,w=100,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "urn<br>rows<br>3"
		};
		
		Text
		{
			font = MyFont,
			name = "urnrows4",
			x=660,y=250,w=100,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "4"
		};

		

		Text
		{
			font = MyFont,
			name = "urnrowslabel4",
			x=660,y=325,w=100,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "urn<br>rows<br>4"
		};
		
		
		
		
		Text
		{
			font = MyFont,
			name = "s1",
			x=25,y=50,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "n1",
			x=25,y=125,w=50,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "Colors"
		};

		---------------------------------------------
		---------------------------

		

		Text
		{
			font = MyFont,
			name = "s2",
			x=75,y=50,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "n2",
			x=75,y=125,w=50,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "color\nbomb"
		};

		---------------------------------------------
		---------------------------

		

		Text
		{
			font = MyFont,
			name = "s3",
			x=125,y=50,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "n3",
			x=125,y=125,w=50,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "area\nbomb"
		};

		---------------------------------------------
		---------------------------

		

		Text
		{
			font = MyFont,
			name = "s4",
			x=175,y=50,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "n4",
			x=175,y=125,w=50,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "wildcard"
		};

		

		Text
		{
			font = MyFont,
			name = "fillrow",
			x=225,y=50,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "fillname",
			x=225,y=125,w=50,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "fillrow"
		};

		----------------------------------------------------

		---------------------------

		

		Text
		{
			font = MyFont,
			name = "s5",
			x=25,y=250,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "n5",
			x=25,y=325,w=50,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "chameleon"
		};

		---------------------------------------------
		---------------------------

		

		Text
		{
			font = MyFont,
			name = "s6",
			x=75,y=250,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "n6",
			x=50,y=330,w=100,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "countdowns"
		};

		---------------------------------------------
		---------------------------

		

		Text
		{
			font = MyFont,
			name = "s7",
			x=125,y=250,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "n7",
			x=100,y=330,w=100,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "countdown<br>start"
		};

		---------------------------------------------
		---------------------------

		

		Text
		{
			font = MyFont,
			name = "s8",
			x=175,y=250,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "n8",
			x=175,y=325,w=50,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "rows"
		};
		-------------------------------------------
		
		Text
		{
			font = MyFont,
			name = "s9",
			x=525,y=50,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "n9",
			x=525,y=125,w=50,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "spawn\nspeed"
		};
		
		-------------------------------------------
		
		Text
		{
			font = MyFont,
			name = "s10",
			x=575,y=50,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "n10",
			x=575,y=125,w=50,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "fall\nspeed"
		};
		
		-------------------------------------------
		
		Text
		{
			font = MyFont,
			name = "s11",
			x=625,y=50,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "n11",
			x=625,y=125,w=50,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "time"
		};
		
		-------------------------------------------
		
		Text
		{
			font = MyFont,
			name = "s12",
			x=675,y=50,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "n12",
			x=675,y=125,w=50,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "shape/goal"
		};
		
		-------------------------------------------
		
		Text
		{
			font = MyFont,
			name = "s13",
			x=725,y=50,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "n13",
			x=725,y=125,w=50,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "min group"
		};
		
		-------------------------------------------
		
		Text
		{
			font = MyFont,
			name = "s14",
			x=17,y=455,w=50,h=75,
			flags = kHAlignCenter + kVAlignCenter,
			label = "0"
		};

		

		Text
		{
			font = MyFont,
			name = "n13",
			x=17,y=505,w=50,h=50,
			flags = kHAlignCenter + kVAlignCenter,
			label = "beetle clicks"
		};
		
		
		--------------------------------------------
		Button
		{
			font = MyFont,
			graphics = NormalButtonGraphics,
			name="play",
			label="Play All Levels",
			type = kPush,
			x=350,
			y=550
		};



		--

		

		
		--

		
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="levelup",
			label="",
			type = kPush,
			x=745,
			y=235,
			scale = kArrowButtonScale
		};
		
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="leveldown",
			label="",
			type = kPush,
			x=745,
			y=310,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="urnrowup1",
			label="",
			type = kPush,
			x=610,
			y=235,
			scale = kArrowButtonScale
		};
		
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="urnrowdown1",
			label="",
			type = kPush,
			x=610,
			y=310,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="urnrowup2",
			label="",
			type = kPush,
			x=640,
			y=235,
			scale = kArrowButtonScale
		};
		
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="urnrowdown2",
			label="",
			type = kPush,
			x=640,
			y=310,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="urnrowup3",
			label="",
			type = kPush,
			x=670,
			y=235,
			scale = kArrowButtonScale
		};
		
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="urnrowdown3",
			label="",
			type = kPush,
			x=670,
			y=310,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="urnrowup4",
			label="",
			type = kPush,
			x=700,
			y=235,
			scale = kArrowButtonScale
		};
		
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="urnrowdown4",
			label="",
			type = kPush,
			x=700,
			y=310,
			scale = kArrowButtonScale
		};
		
		
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="up1",
			label="",
			type = kPush,
			x=35,
			y=35,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="down1",
			label="",
			type = kPush,
			x=35,
			y=110,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="up2",
			label="",
			type = kPush,
			x=85,
			y=35,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="down2",
			label="",
			type = kPush,
			x=85,
			y=110,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="up3",
			label="",
			type = kPush,
			x=135,
			y=35,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="down3",
			label="",
			type = kPush,
			x=135,
			y=110,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="up4",
			label="",
			type = kPush,
			x=185,
			y=35,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="down4",
			label="",
			type = kPush,
			x=185,
			y=110,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="fillup",
			label="",
			type = kPush,
			x=235,
			y=35,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="filldown",
			label="",
			type = kPush,
			x=235,
			y=110,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="up5",
			label="",
			type = kPush,
			x=35,
			y=235,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="down5",
			label="",
			type = kPush,
			x=35,
			y=310,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="up6",
			label="",
			type = kPush,
			x=85,
			y=235,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="down6",
			label="",
			type = kPush,
			x=85,
			y=310,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="up7",
			label="",
			type = kPush,
			x=135,
			y=235,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="down7",
			label="",
			type = kPush,
			x=135,
			y=310,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="up8",
			label="",
			type = kPush,
			x=185,
			y=235,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="down8",
			label="",
			type = kPush,
			x=185,
			y=310,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="up9",
			label="",
			type = kPush,
			x=535,
			y=35,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="down9",
			label="",
			type = kPush,
			x=535,
			y=110,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="up10",
			label="",
			type = kPush,
			x=585,
			y=35,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="down10",
			label="",
			type = kPush,
			x=585,
			y=110,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="up11",
			label="",
			type = kPush,
			x=635,
			y=35,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="down11",
			label="",
			type = kPush,
			x=635,
			y=110,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="up12",
			label="",
			type = kPush,
			x=685,
			y=35,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="down12",
			label="",
			type = kPush,
			x=685,
			y=110,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="up13",
			label="",
			type = kPush,
			x=735,
			y=35,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="down13",
			label="",
			type = kPush,
			x=735,
			y=110,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowUpButtonGraphics,
			name="beetleclicksup",
			label="",
			type = kPush,
			x=30,
			y=465,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = ArrowDownButtonGraphics,
			name="beetleclicksdown",
			label="",
			type = kPush,
			x=30,
			y=500,
			scale = kArrowButtonScale
		};
		
		Button
		{
			font = MyFont,
			graphics = NormalButtonGraphics,
			name="test",
			label="Test This Level",
			type = kPush,
			x=200,
			y=550
		};
		
		BeginGroup();
		
		Button
   		{
   			font = MyFont,
   			graphics = RadioButtonGraphics,
   			name="bucket",
   			label="      Bucket Mode",
   			type = kRadio,
   			x=25,
   			y=375,
   			w=200,
   			scale = 0.5,
   			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg"
   		};

   		Button
   		{
   			font = MyFont,
   			graphics = RadioButtonGraphics,
   			name="search",
   			label="      Search Mode",
   			type = kRadio,
   			x=25,
   			y=400,
   			w=200,
   			scale = 0.5,
   			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg"
   		};

   		Button
   		{
   			font = MyFont,
   			graphics = RadioButtonGraphics,
   			name="pinata",
   			label="      Pinata Mode",
   			type = kRadio,
   			x=25,
   			y=425,
   			w=200,
   			scale = 0.5,
   			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg"
   		};
		
		BeginGroup();
		
		Button
		{
			font = MyFont,
			graphics = RadioButtonGraphics,
			name="tri",
			label="      Triangle Board",
			type = kRadio,
			x=25,
			y=550,
			w=200,
			scale = 0.5,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg"
		};

		Button
		{
			font = MyFont,
			graphics = RadioButtonGraphics,
			name="hex",
			label="      Hexagon Board",
			type = kRadio,
			x=25,
			y=575,
			w=200,
			scale = 0.5,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg"
		};
		
		
		Button
		{
			font = MyFont,
			graphics = RadioButtonGraphics,
			name="randchameleon",
			label="Random Chameleons",
			type = kToggle,
			x=600,
			y=400,
			w=150,
			scale = 0.5,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg"
		};
		
		Button
		{
			font = MyFont,
			graphics = RadioButtonGraphics,
			name="flashlight",
			label="Flash Light Mode",
			type = kToggle,
			x=600,
			y=450,
			w=150,
			scale = 0.5,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg"
		};
		
		Bitmap
		{
			image="backgrounds/textfield.png",
			x=735,
			y=400,
			scale=0.5,
			
			TextEdit
			{
				font = LevelNumFont,
				name = "leveledit",
				label="1",
				x=10,y=0,w=kMax,h=kMax,
				length=12
				
			};
		};
		
		Button
		{
			font = MyFont,
			graphics = NormalButtonGraphics,
			name="setlevel",
			label="Set Level",
			type = kPush,
			scale = 0.5,
			x=735,
			y=440
		};
		
		
		BeginGroup();
		
		Button
		{
			font = MyFont,
			graphics = RadioButtonGraphics,
			name="wheelpoints",
			label="      Wheel Points",
			type = kRadio,
			x=600,
			y=500,
			w=200,
			scale = 0.5,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg"
		};

		Button
		{
			font = MyFont,
			graphics = RadioButtonGraphics,
			name="wheel2tri",
			label="      Wheel 2-tri",
			type = kRadio,
			x=600,
			y=525,
			w=200,
			scale = 0.5,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg"
		};
		
		Button
		{
			font = MyFont,
			graphics = RadioButtonGraphics,
			name="wheelbombs",
			label="      Wheel Bombs",
			type = kRadio,
			x=600,
			y=550,
			w=200,
			scale = 0.5,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg"
		};

		Button
		{
			font = MyFont,
			graphics = RadioButtonGraphics,
			name="wheeldeadtri",
			label="      Wheel CrackedTri",
			type = kRadio,
			x=600,
			y=575,
			w=200,
			scale = 0.5,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg"
		};
		
		
		
		
		
		
	}
}
---------------------------


