require( "screens/style.lua" );

HeaderFont = {
  standardFont,
  50,
  YellowColor
};

HeaderShadowFont = {
  standardFont,
  50,
  BlackColor
};

TableInfoFont = {
  standardFont,
  30,
 YellowColor
};

ErrorFont = {
  standardFont,
  24,
 YellowColor
};

AccountFont = {
  standardFont,
  24,
  YellowColor
};

ScoreFont = {
  standardFont,
  14,
  YellowColor
};

kPlayerNameY = 150;
kScoreY = 200;
kYourPFAccountY = 235;
kAccountNameY = 275;
kPasswordY = 310;
kRememberY = 350;


MakeDialog
{
	
	Bitmap
	{ 
		image="backgrounds/large_dialog.jpg",	
		x=kLargeDialogX,
		y=kLargeDialogY,
		
		
		Text
		{
			font = HeaderShadowFont,
			name = "headershadow",
			x=kLargeDialogLeftX+1,y=40+1,w=kLargeDialogWidth,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "submitglobal"
		};
		
		Text
		{
			font = HeaderFont,
			name = "header",
			x=kLargeDialogLeftX,y=40,w=kLargeDialogWidth,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "submitglobal"
		};
		
		Text
		{
			font = AccountFont,
			name = "playertext",
			x=0,y=kPlayerNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "playerlabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "yourscore",
			x=0,y=kScoreY,w=142,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "scorelabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "eligiblescore",
			x=205,y=kScoreY,w=100,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			label = "12345"
		};
		
		Text
		{
			font = ScoreFont,
			name = "yourpfaccount",
			x=145,y=kYourPFAccountY,w=150,h=kMax,
			flags = kHAlignLeft + kVAlignTop,
			label = "yourpfaccount"
		};
		
		Text
		{
			font = AccountFont,
			name = "nametext",
			x=0,y=kAccountNameY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "namelabel"
		};
		
		Text
		{
			font = AccountFont,
			name = "passtext",
			x=0,y=kPasswordY,w=145,h=kMax,
			flags = kHAlignRight + kVAlignTop,
			label = "passwordlabel"
		};
		
		Text
		{
			font = TableInfoFont,
			name = "submitconnect",
			x=0,y=0,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignCenter,
			label = "connectingtoserver"
		};
		
		Text
		{
			font = ErrorFont,
			name = "submiterror",
			x=kLargeDialogLeftX,y=0,w=kLargeDialogWidth,h=kMax,
			flags = kHAlignCenter + kVAlignCenter,
			label = "Error Message"
		};


		Bitmap
		{
			name="nameeditbox",
			image="backgrounds/textfield.png",
			x=155,
			y=kPlayerNameY,
			
			TextEdit
			{
				font = AccountFont,
				name = "nameedit",
				x=0,y=3,w=kMax,h=kMax,
				length=12
				
			};
		};
		
		Bitmap
		{
			name="accounteditbox",
			image="backgrounds/textfield.png",
			x=155,
			y=kAccountNameY,
			
			TextEdit
			{
				font = AccountFont,
				name = "accountedit",
				x=0,y=3,w=kMax,h=kMax,
				length=26
				
			};
		};
		
		Bitmap
		{
			name="passeditbox",
			image="backgrounds/textfield.png",
			x=155,
			y=kPasswordY,
			
			TextEdit
			{
				font = AccountFont,
				name = "passedit",
				x=0,y=3,w=kMax,h=kMax,
				password = true,
				length=26
				
			};
		};
		
		
		Button
		{
			font = NormalButtonFont,
			graphics = RadioButtonGraphics,
			name="remember",
			type = kToggle,
			x=75,
			y=kRememberY,
			w=250,
			scale=0.5,
			rollover = "",
			drop = false,
			sound = "audio/sfx/checkbox.ogg",
			Text
			{
				font = NormalButtonFont,
				name = "rememberlabel",
				x=25,
				y=10,
				w=250,
				h=25,
				flags = kHAlignLeft + kVAlignTop,
				label="rememberpfaccount",
			};
		};
		
		
		TriclopsButton
		{
			x=50,
			y=400,
			Button
			{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="submittoserver",
				label="submit",
				type = kPush,
				scale = 0.61
			};
		},
		
		TriclopsButton
		{
			x=237,
			y=400,
			Button
			{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="submitcancel",
				label="cancel",
				type = kPush,
				scale = 0.61
			};
		},
		
		TriclopsButton
		{
			x=150,
			y=400,
			Button
			{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="submiterrorok",
				label="ok",
				type = kPush,
				scale = 0.61
			};
		}
	}
}