require( "screens/style.lua" );

HeaderFont = {
  standardFont,
  70,
  DoorMenuOrangeColor2
};


GameModeFont = {
  standardFont,
  50,
  YellowColor
};

TableInfoFont = {
  standardFont,
  30,
  YellowColor
};

ConnectingToServerFont = {
	standardFont,
	18,
	YellowColor
};

TableHeaderFont = {
  standardFont,
  30,
  WhiteColor
};

ScoreInfoFont = {
  standardFont,
  18,
  YellowColor
};


ScoreFont = {
  standardFont,
  20,
  YellowColor
};

RankFont = {
  standardFont,
  26,
  YellowColor
};

ChangeViewFont = {
  standardFont,
  16,
  ButtonTextColor
};

LeftButtonGraphics = {
	"buttons/arrowleft_up.png",
	"buttons/arrowleft_down.png",
	"buttons/arrowleft_over.png"
};

RightButtonGraphics = {
	"buttons/arrowright_up.png",
	"buttons/arrowright_down.png",
	"buttons/arrowright_over.png"
};

BlueLeftButtonGraphics = {
	"buttons/bluearrowleft_up.png",
	"buttons/bluearrowleft_down.png",
	"buttons/bluearrowleft_over.png"
};

BlueRightButtonGraphics = {
	"buttons/bluearrowright_up.png",
	"buttons/bluearrowright_down.png",
	"buttons/bluearrowright_over.png"
};

UpButtonGraphics = {
	"buttons/arrowup_up.png",
	"buttons/arrowup_down.png",
	"buttons/arrowup_over.png"
};

DownButtonGraphics = {
	"buttons/arrowdown_up.png",
	"buttons/arrowdown_down.png",
	"buttons/arrowdown_over.png"
};

ChangeViewButtonGraphics = {
	"buttons/long_button_up.png",
	"buttons/long_button_down.png",
	"buttons/long_button_over.png"
};


kScoreRowSpace = 25;
kRowY = 75;
kNumberX = 30;
kNameX = 47;
kScoreX = 330;
kP1X = kNumberX + 1;



MakeDialog
{
	
	Bitmap
	{ 
		image="backgrounds/full_screen_dialog.jpg",	
		name="hiscorescreen",
		
		Text
		{
			font = HeaderFont,
			name = "header",
			x=0,y=50,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "highscoresoutline"
		};
		
		Text
		{
			font = GameModeFont,
			name = "gamemode",
			x=0,y=105,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "GAMEMODE"
		};
		
		Bitmap
		{
			x = 70,
			y = 150,
			image="backgrounds/global-hs-bb_large.png",	
			name="leftpanel",
			
			Text
			{
				font = TableHeaderFont,
				name = "local",
				x=0,y=10,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "localhighscores"
			};
			
			
			Text
			{
				font = TableHeaderFont,
				name = "global",
				x=0,y=10,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "globalhighscores"
			};
			
			Text
			{
				font = TableHeaderFont,
				name = "topplayers",
				x=0,y=10,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "topplayers"
			};
			
			Text
			{
				font = ScoreFont,
				name = "1",
				x=0,y=kRowY,w=kNumberX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "1."
			};
			
			Bitmap
			{
				image = "p1icon.png",
				name = "image1",
				x=kP1X,y=kRowY
			};
			
			Text
			{
				font = ScoreFont,
				name = "name1",
				x=kNameX,y=kRowY,w=kMax,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "name"
			};
			
			Text
			{
				font = ScoreFont,
				name = "score1",
				x=0,y=kRowY,w=kScoreX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "12345"
			};
			
			Text
			{
				font = ScoreFont,
				name = "2",
				x=0,y=kRowY+(1*kScoreRowSpace),w=kNumberX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "2."
			};
			
			Bitmap
			{
				image = "p1icon.png",
				name = "image2",
				x=kP1X,y=kRowY+(1*kScoreRowSpace)
			};
			
			
			Text
			{
				font = ScoreFont,
				name = "name2",
				x=kNameX,y=kRowY+(1*kScoreRowSpace),w=kMax,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "name"
			};
			
			Text
			{
				font = ScoreFont,
				name = "score2",
				x=0,y=kRowY+(1*kScoreRowSpace),w=kScoreX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "12345"
			};
			
			Text
			{
				font = ScoreFont,
				name = "3",
				x=0,y=kRowY+(2*kScoreRowSpace),w=kNumberX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "3."
			};
			
			Bitmap
			{
				image = "p1icon.png",
				name = "image3",
				x=kP1X,y=kRowY+(2*kScoreRowSpace)
			};
			
			Text
			{
				font = ScoreFont,
				name = "name3",
				x=kNameX,y=kRowY+(2*kScoreRowSpace),w=kMax,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "name"
			};
			
			Text
			{
				font = ScoreFont,
				name = "score3",
				x=0,y=kRowY+(2*kScoreRowSpace),w=kScoreX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "12345"
			};
			
			Text
			{
				font = ScoreFont,
				name = "4",
				x=0,y=kRowY+(3*kScoreRowSpace),w=kNumberX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "4."
			};
			
			Bitmap
			{
				image = "p1icon.png",
				name = "image4",
				x=kP1X,y=kRowY+(3*kScoreRowSpace)
			};
			
			Text
			{
				font = ScoreFont,
				name = "name4",
				x=kNameX,y=kRowY+(3*kScoreRowSpace),w=kMax,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "name"
			};
			
			Text
			{
				font = ScoreFont,
				name = "score4",
				x=0,y=kRowY+(3*kScoreRowSpace),w=kScoreX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "12345"
			};
			
			Text
			{
				font = ScoreFont,
				name = "5",
				x=0,y=kRowY+(4*kScoreRowSpace),w=kNumberX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "5."
			};
			
			Bitmap
			{
				image = "p1icon.png",
				name = "image5",
				x=kP1X,y=kRowY+(4*kScoreRowSpace)
			};
			
			Text
			{
				font = ScoreFont,
				name = "name5",
				x=kNameX,y=kRowY+(4*kScoreRowSpace),w=kMax,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "name"
			};
			
			Text
			{
				font = ScoreFont,
				name = "score5",
				x=0,y=kRowY+(4*kScoreRowSpace),w=kScoreX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "12345"
			};
			
			Text
			{
				font = ScoreFont,
				name = "6",
				x=0,y=kRowY+(5*kScoreRowSpace),w=kNumberX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "6."
			};
			
			Bitmap
			{
				image = "p1icon.png",
				name = "image6",
				x=kP1X,y=kRowY+(5*kScoreRowSpace)
			};
			
			Text
			{
				font = ScoreFont,
				name = "name6",
				x=kNameX,y=kRowY+(5*kScoreRowSpace),w=kMax,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "name"
			};
			
			Text
			{
				font = ScoreFont,
				name = "score6",
				x=0,y=kRowY+(5*kScoreRowSpace),w=kScoreX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "12345"
			};
			
			Text
			{
				font = ScoreFont,
				name = "7",
				x=0,y=kRowY+(6*kScoreRowSpace),w=kNumberX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "7."
			};
			
			Bitmap
			{
				image = "p1icon.png",
				name = "image7",
				x=kP1X,y=kRowY+(6*kScoreRowSpace)
			};
			
			Text
			{
				font = ScoreFont,
				name = "name7",
				x=kNameX,y=kRowY+(6*kScoreRowSpace),w=kMax,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "name"
			};
			
			Text
			{
				font = ScoreFont,
				name = "score7",
				x=0,y=kRowY+(6*kScoreRowSpace),w=kScoreX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "12345"
			};
			
			Text
			{
				font = ScoreFont,
				name = "8",
				x=0,y=kRowY+(7*kScoreRowSpace),w=kNumberX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "8."
			};
			
			Bitmap
			{
				image = "p1icon.png",
				name = "image8",
				x=kP1X,y=kRowY+(7*kScoreRowSpace)
			};
			
			Text
			{
				font = ScoreFont,
				name = "name8",
				x=kNameX,y=kRowY+(7*kScoreRowSpace),w=kMax,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "name"
			};
			
			Text
			{
				font = ScoreFont,
				name = "score8",
				x=0,y=kRowY+(7*kScoreRowSpace),w=kScoreX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "12345"
			};
			
			Text
			{
				font = ScoreFont,
				name = "9",
				x=0,y=kRowY+(8*kScoreRowSpace),w=kNumberX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "9."
			};
			
			Bitmap
			{
				image = "p1icon.png",
				name = "image9",
				x=kP1X,y=kRowY+(8*kScoreRowSpace)
			};
			
			Text
			{
				font = ScoreFont,
				name = "name9",
				x=kNameX,y=kRowY+(8*kScoreRowSpace),w=kMax,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "name"
			};
			
			Text
			{
				font = ScoreFont,
				name = "score9",
				x=0,y=kRowY+(8*kScoreRowSpace),w=kScoreX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "12345"
			};
			
			Text
			{
				font = ScoreFont,
				name = "10",
				x=0,y=kRowY+(9*kScoreRowSpace),w=kNumberX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "10."
			};
			
			Bitmap
			{
				image = "p1icon.png",
				name = "image10",
				x=kP1X,y=kRowY+(9*kScoreRowSpace)
			};
			
			Text
			{
				font = ScoreFont,
				name = "name10",
				x=kNameX,y=kRowY+(9*kScoreRowSpace),w=kMax,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "name"
			};
			
			Text
			{
				font = ScoreFont,
				name = "score10",
				x=0,y=kRowY+(9*kScoreRowSpace),w=kScoreX,h=kMax,
				flags = kHAlignRight + kVAlignTop,
				label = "12345"
			};
			
		};
		
		Bitmap
		{
			x = 470,
			y = 150,
			image="backgrounds/global-hs-bb_small.png",	
			name="rightpanelsmall",
			
			Text
			{
				font = ScoreInfoFont,
				name = "yourrankglobalinfo",
				x=10,y=55,w=kMax-10,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "globalhighscoreinfo"
			};
			
			Text
			{
				font = RankFont,
				name = "yourrank",
				x=10,y=15,w=kMax-10,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "yourrank"
			};
			
			Text
			{
				font = RankFont,
				name = "congratulations",
				x=10,y=50,w=kMax-10,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "congratshighscore"
			};
			
			Text
			{
				font = RankFont,
				name = "dnq",
				x=10,y=50,w=kMax-10,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "scorednq"
			};
		},
		
		
		Bitmap
		{
			x = 470,
			y = 150,
			image="backgrounds/local-hs-bb.png",	
			name="rightpanel",
			
			Text
			{
				font = TableHeaderFont,
				name = "globalinfoheader",
				x=0,y=15,w=kMax,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "globalhighscores"
			};
			
			Text
			{
				font = ScoreInfoFont,
				name = "info",
				x=10,y=55,w=kMax-10,h=kMax,
				flags = kHAlignCenter + kVAlignTop,
				label = "globalhighscoreinfo"
			};
			
			TriclopsButton
			{
				x=85,
				y=130,
				Button
				{
					font = NormalButtonFont,
					graphics = NormalButtonGraphics,
					name="moreinfo",
					label="moreinfo",
					type = kPush,
					scale = 0.61
					
				};
			},
			
			
			Text
			{
				font = TableInfoFont,
				name = "eligible",
				x=10,y=180,w=kMax-10,h=60,
				flags = kHAlignCenter + kVAlignTop,
				label = "eligible"
			};
		
			TriclopsButton
			{
				x=85,
				y=240,
				Button
				{
					font = NormalButtonFont,
					graphics = NormalButtonGraphics,
					name="submit",
					label="submit",
					type = kPush,
					scale = 0.61
				};
			},
			
		};
		
		
		
		Text
		{
			font = ConnectingToServerFont,
			name = "server",
			x=485,y=362,w=258,h=130,
			flags = kHAlignCenter + kVAlignCenter,
			label = "connectingtoserver"
		};
		
		Text
		{
			font = ConnectingToServerFont,
			name = "error",
			x=485,y=362,w=258,h=130,
			flags = kHAlignCenter + kVAlignCenter,
			label = "Server error"
		};
		
		
		
		Text
		{
			font = ScoreFont,
			name = "category",
			x=163,y=197,w=201,h=40,
			flags = kHAlignCenter + kVAlignTop,
			label = "Category Name"
		};
		
		
		

		
		
		
		
		
		
		Button
		{
			font = NormalButtonFont,
			graphics = LeftButtonGraphics,
			name="gamemodeleft",
			label="",
			type = kPush,
			x=160,
			y=100,
			scale = 0.8
		};
		
		Button
		{
			font = NormalButtonFont,
			graphics = RightButtonGraphics,
			name="gamemoderight",
			label="",
			type = kPush,
			x=570,
			y=100,
			scale = 0.8
		};
		
		Button
		{
			font = NormalButtonFont,
			graphics = BlueLeftButtonGraphics,
			name="categoryleft",
			label="",
			type = kPush,
			x=160,
			y=185,
			scale = 0.8
		};
		
		Button
		{
			font = NormalButtonFont,
			graphics = BlueRightButtonGraphics,
			name="categoryright",
			label="",
			type = kPush,
			x=330,
			y=185,
			scale = 0.8
		};
		
		Button
		{
			font = NormalButtonFont,
			graphics = UpButtonGraphics,
			name="scrollup",
			label="",
			type = kPush,
			x=420,
			y=225,
			scale = 0.8
		};
		
		Button
		{
			font = NormalButtonFont,
			graphics = DownButtonGraphics,
			name="scrolldown",
			label="",
			type = kPush,
			x=420,
			y=430,
			scale = 0.8
		};
		
		
		
		TriclopsButton
		{
			x=170,
			y=500,
			Button
			{
				font = ChangeViewFont,
				graphics = ChangeViewButtonGraphics,
				name="view",
				label="viewglobal",
				type = kPush
			};
		},
		
		TriclopsButton
		{
			x=170,
			y=500,
			Button
			{
				font = ChangeViewFont,
				graphics = ChangeViewButtonGraphics,
				name="viewlocal",
				label="viewlocal",
				type = kPush
			};
		},
		
		
		
		
		TriclopsButton
		{
			x=625,
			y=500,
			Button
			{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="ok",
				type = kPush,
				scale = 0.61,
				Text
				{
					font = ButtonFont,
					name="backtomenu1",
					label="backtomenu1",
					x=0,
					y=9,
					w=kMax,
					h=100,
					flags = kHAlignCenter + kVAlignTop
				},
				Text
				{
					font = ButtonFont,
					name="backtomenu2",
					label="backtomenu2",
					x=0,
					y=25,
					w=kMax,
					h=100,
					flags = kHAlignCenter + kVAlignTop
				},
			};
		}
	}
}