require( "screens/style.lua" )


HiscoreFont = {
  standardFont,
  16,
  YellowColor
};

StatFont = {
  standardFont,
  24,
  YellowColor
};

StatShadowFont = {
  standardFont,
  24,
  BlackColor
};

TipFont = {
  standardFont,
  20,
  YellowColor
};


TrappedFont = {
	standardFont,
	40,
	YellowColor,
};

TrappedShadowFont = {
	standardFont,
	40,
	BlackColor,
};

PlayToEscapeFont = {
	standardFont,
	30,
	YellowColor,
};

PlayToEscapeShadowFont = {
	standardFont,
	30,
	BlackColor,
};



MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/large_dialog.jpg",	
		x=kLargeDialogX,
		y=kLargeDialogY,

		Text
		{
			font = TrappedShadowFont,
			name = "youaretrappedshadow",
			label = "youaretrapped",
			flags = kHAlignCenter + kVAlignTop,
			x=kLargeDialogLeftX+2,y=42,w=kLargeDialogWidth,h=80
		},
		
		Text
		{
			font = TrappedFont,
			name = "youaretrapped",
			label = "youaretrapped",
			flags = kHAlignCenter + kVAlignTop,
			x=kLargeDialogLeftX,y=40,w=kLargeDialogWidth,h=80
		},
		
		Text
		{
			font = PlayToEscapeShadowFont,
			name = "playtoescapeshadow",
			label = "playtoescape",
			flags = kHAlignCenter + kVAlignTop,
			x=kLargeDialogLeftX+2,y=82,w=kLargeDialogWidth,h=40
		},
		
		Text
		{
			font = PlayToEscapeFont,
			name = "playtoescape",
			label = "playtoescape",
			flags = kHAlignCenter + kVAlignTop,
			x=kLargeDialogLeftX,y=80,w=kLargeDialogWidth,h=40
		},
		
		
		
		
		
		
		
		
		Bitmap
		{ 
			image="backgrounds/artifacts-bb.png",	
			name="loserhint",
			x=35,
			y=130,
		
			Text
			{
				font = StatFont,
				name = "hint",
				label = "hint",
				flags = kHAlignCenter + kVAlignTop,
				x=0,y=10,w=kMax,h=50
			},
			
			Text
			{
				font = TipFont,
				name = "losertip",
				flags = kHAlignCenter + kVAlignCenter,
				x=35,y=30,w=kMax-35,h=150,
				label = "loser_tip_13"
				
			};
		},
		
		Bitmap
		{ 
			image="backgrounds/end-game-button.png",	
			name="winbutton",
			x=kCenter,
			y=105,
		},
		
		Bitmap
		{ 
			image="backgrounds/end-game-bb.png",	
			name="congratulationswindow",
			x=35,
			y=265,
		

			
			Text
			{
				font = TipFont,
				name = "congratulations",
				flags = kHAlignCenter + kVAlignCenter,
				x=10,y=0,w=kMax-10,h=kMax,
				label = "congratulations"
				
			};
		},
		
		
		Text
		{
			font = HiscoreFont,
			name = "newhighscore",
			x=10,y=325,w=kMax-10 ,h=60,
			flags = kHAlignCenter + kVAlignTop,
			label = "newhighscore"
		},
		
		Text
		{
			font = StatShadowFont,
			name = "finalscoreshadow",
			x=2,y=372,w=kMax ,h=30,
			flags = kHAlignCenter + kVAlignTop,
			label = "finalscore"
		},
		
		Text
		{
			font = StatFont,
			name = "finalscore",
			x=0,y=370,w=kMax ,h=30,
			flags = kHAlignCenter + kVAlignTop,
			label = "finalscore"
		},
		
		



		TriclopsButton 
		{
			x=141,
			y=405,
			Button{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="playagain",
				Text
				{
					font = NormalButtonFont,
					name="playagainlabel1",
					label="playagainlabel1",
					x=0,
					y=9,
					w=kMax,
					h=20,
					flags = kHAlignCenter + kVAlignTop
				},
				Text
				{
					font = NormalButtonFont,
					name="playagainlabel2",
					label="playagainlabel2",
					x=0,
					y=25,
					w=kMax,
					h=20,
					flags = kHAlignCenter + kVAlignTop
				},
				type = kPush,
				scale = 0.61
			};
		},
		
		TriclopsButton 
		{
			x=141,
			y=405,
			Button{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="map",
				label="map",
				type = kPush,
				scale = 0.61
			};
		},
		
		TriclopsButton 
		{
			x=249,
			y=405,
			Button{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="mainmenu",
				label="mainmenu",
				type = kPush,
				scale = 0.61
			};
		},
		
		TriclopsButton 
		{
			x=32,
			y=405,
			Button{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="highscores",
				label="",
				type = kPush,
				scale = 0.61,
				Text
				{
					font = NormalButtonFont,
					name="view_label",
					label="viewhighscoreslabel1",
					x=0,
					y=9,
					w=kMax,
					h=20,
					flags = kHAlignCenter + kVAlignTop
				},
				Text
				{
					font = NormalButtonFont,
					name="highscores_label",
					label="viewhighscoreslabel2",
					x=0,
					y=25,
					w=kMax,
					h=20,
					flags = kHAlignCenter + kVAlignTop
				},
			};
		}
	}
}



