require( "screens/style.lua" );


BodyFont = {
  standardFont,
  16,
  ButtonTextColor
};

PauseFont = {
  standardFont,
  20,
  ButtonTextColor
};

ScoreFont = {
  standardFont,
  32,
  ScoreColor
};

LevelFont = {
  standardFont,
  22,
  ScoreColor
};

LevelShadowFont = {
  standardFont,
  22,
  BlackColor
};

ScoreShadowFont = {
  standardFont,
  32,
  BlackColor
};

ScoreNumberFont = {
  standardFont,
  27,
  ScoreColor
};

ScoreNumberShadowFont = {
  standardFont,
  27,
  BlackColor
};

MakeDialog
{
	ChamberImage					
	{ 
		name="chamberimage",	

		GameWindow
		{
			x=0,y=000,
			w=800,h=600,
			name="mainGameWindow",
			

			
			Text
			{
				font = ScoreShadowFont,
				name = "bonuslabelshadow",
				x=326,y=46,w=305,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "0"
			};
			
			
			Text
			{
				font = ScoreFont,
				name = "bonuslabel",
				x=325,y=45,w=305,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "bonus"
			};
			
			

			Text
			{
				font = ScoreShadowFont,
				name = "shapefoundlabelshadow",
				x=326,y=21,w=305,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "0"
			};
			
			
			Text
			{
				font = ScoreFont,
				name = "shapefoundlabel",
				x=325,y=20,w=305,h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label = "found"
			};

			
			Bitmap
			{ 
				name="scorewindow",
				image="scorecloud.png",	
				x=10,
				y=15,

				
				Text
				{
					font = ScoreShadowFont,
					name = "scorelabelshadow",
					x=10,y=2,w=100,h=48,
					flags = kHAlignLeft + kVAlignCenter,
					label = "scorelabelbold"
				};

				Text
				{
					font = ScoreNumberShadowFont,
					name = "scoreshadow",
					x=1,y=2,w=293,h=48,
					flags = kHAlignCenter + kVAlignCenter,
					label = "0"
				};
				
				Text
				{
					font = ScoreFont,
					name = "scorelabel",
					x=9,y=0,w=100,h=48,
					flags = kHAlignLeft + kVAlignCenter,
					label = "scorelabelbold"
				};

				Text
				{
					font = ScoreNumberFont,
					name = "score",
					x=0,y=0,w=293,h=48,
					flags = kHAlignCenter + kVAlignCenter,
					label = "0"
				};
				
				
				Text
				{
					font = LevelShadowFont,
					name = "levellabelshadow",
					x=127,y=47,w=100,h=kMax,
					flags = kHAlignLeft + kVAlignCenter,
					label = "levellabelbold"
				};
				
				Text
				{
					font = LevelFont,
					name = "levellabel",
					x=126,y=45,w=100,h=kMax,
					flags = kHAlignLeft + kVAlignCenter,
					label = "levellabelbold"
				};
				
				

				Text
				{
					font = LevelShadowFont,
					name = "levelshadow",
					x=161,y=47,w=40,h=kMax,
					flags = kHAlignCenter + kVAlignCenter,
					label = "0"
				};
				
				Text
				{
					font = LevelFont,
					name = "level",
					x=160,y=45,w=40,h=kMax,
					flags = kHAlignCenter + kVAlignCenter,
					label = "0"
				};
			};
			
			
			TriclopsButton
			{
				x=710,
				y=10,
				Button
				{
					font = PauseFont,
					graphics = NormalButtonGraphics,
					name="Pause",
					label="pause",
					type = kPush,
					scale = 0.5
					
				};
			},

			

			Button
			{
				font = BasicFont16,
				graphics = {"buttons/rotleft_up.png","buttons/rotleft_down.png","buttons/rotleft_over.png"},
				name="rotleft",
				label="",
				type = kPush,
				x=354,
				y=552,
				sound="",
				rollover=""
			};

			Button
			{
				font = BasicFont16,
				graphics = {"buttons/rotright_up.png","buttons/rotright_down.png","buttons/rotright_over.png"},
				name="rotright",
				label="",
				type = kPush,
				x=405,
				y=552,
				sound="",
				rollover=""
			};
			
			
			Bitmap
			{ 
				name="helptipwindow",
				image="helptips/helptip.jpg",	
				x=584,
				y=439,

				
				Text
				{
					font = BodyFont,
					name = "bodyalt",
					x=12,y=22,w=125,h=122,
					flags = kHAlignCenter + kVAlignCenter,
					label = "body"
				};
				
				Text
				{
					font = BodyFont,
					name = "body",
					x=12,y=22,w=125,h=122,
					flags = kHAlignCenter + kVAlignCenter,
					label = "body"
				};
				
				Bitmap
				{
					name="arrowkeys",
					image="helptips/arrowkeys.png",
					x=13,
					y=83
				},
				


				TriclopsButton
				{
					x=10,
					y=130,
					Button{
						font = NormalButtonFont,
						graphics = NormalButtonGraphics,
						name="helptipclosealt",
						label="ok",
						type = kPush,
						scale = 0.3
						
					};
				},
				
				TriclopsButton
				{
					x=10,
					y=130,
					Button{
						font = NormalButtonFont,
						graphics = NormalButtonGraphics,
						name="helptipclose",
						label="ok",
						type = kPush,
						scale = 0.3
						
					};
				}
				
			}
		};
		
		
		
		
	}
}

