require( "screens/style.lua" );


TitleFont = {
  standardFont,
  24,
  YellowColor
};

TitleShadowFont = {
  standardFont,
  24,
  BlackColor
};

NewDeleteFont = 
{
  standardFont,
  12,
  ButtonTextColor
};

OptionsFont = {
  standardFont,
  18,
  ButtonTextColor
};

NameFont = {
  standardFont,
  24,
  WhiteColor
};

HeaderFont = {
  standardFont,
  48,
  YellowColor
};

HeaderShadowFont = {
  standardFont,
  48,
  BlackColor
};

OneLineButtonFont = {
  standardFont,
  18,
  ButtonTextColor
};

TwoLineButtonFont = {
 standardFont,
  16,
  ButtonTextColor
};


ButtonX = kCenter;
ButtonY = 90;
ButtonYSpace = 30;


NameButtonGraphics = {
	"buttons/choosenameover.png",
	"buttons/choosenameover.png",
	"buttons/choosenameover.png"
};

NameStyle= {
	type = kRadio,
	flags = kHAlignCenter + kVAlignCenter,
	font = NameFont,
	graphics = NameButtonGraphics,
	sound = kDefaultButtonSound
};


MakeDialog
{
	Bitmap
	{ 
		image="backgrounds/large_dialog.jpg",
		x=kCenter,
		y=kCenter,
		
		
		Text
		{
			font = HeaderShadowFont,
			name = "selectaplayershadow",
			x=1,y=41,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "selectaplayer"
		};
		
		Text
		{
			font = HeaderFont,
			name = "selectaplayer",
			x=0,y=40,w=kMax,h=kMax,
			flags = kHAlignCenter + kVAlignTop,
			label = "selectaplayer"
		};
		
		Bitmap
		{
			name="nameBox",
			image="buttons/choosenamedown.png"
		};
			
		SetStyle(NameStyle);
		BeginGroup();
		Button{
			name="button0",
			label="name",
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*0),
		};
		
		Button{
			name="button1",
			label="name",
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*1)
		};
		
		Button{
			name="button2",
			label="name",
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*2)
		};
		
		Button{
			name="button3",
			label="name",
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*3)
		};
		
		Button{
			name="button4",
			label="name",
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*4)
		};
		
		Button{
			name="button5",
			label="name",
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*5)
		};
		Button{
			name="button6",
			label="name",
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*6)
		};
		Button{
			name="button7",
			label="name",
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*7)
		};
		Button{
			name="button8",
			label="name",
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*8)
		};
		Button{
			name="button9",
			label="name",
			x=ButtonX,
			y=ButtonY+(ButtonYSpace*9)
		};
		
		TriclopsButton
		{
			x=193,
			y=410,
			Button{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="editname",
				label="",
				type = kPush,
				scale=0.45,
				Text
				{
					font = TwoLineButtonFont,
					name="editnamebutton_label",
					label="edit",
					x=0,
					y=6,
					w=kMax,
					h=25,
					flags = kHAlignCenter + kVAlignTop
				},
				Text
				{
					font = TwoLineButtonFont,
					name="editnameplayerbutton_label",
					label="name",
					x=0,
					y=18,
					w=kMax,
					h=25,
					flags = kHAlignCenter + kVAlignTop
				},
			};
		},
		
		TriclopsButton
		{
			x=273,
			y=410,
			Button{
				font = OneLineButtonFont,
				graphics = NormalButtonGraphics,
				name="chooseok",
				label="ok",
				type = kPush,
				scale = 0.45
				
			};
		},
		
		TriclopsButton
		{
			x=33,
			y=410,
			Button{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="new",
				label="",
				type = kPush,
				scale=0.45,
				Text
				{
					font = TwoLineButtonFont,
					name="newbutton_label",
					label="new",
					x=0,
					y=6,
					w=kMax,
					h=25,
					flags = kHAlignCenter + kVAlignTop
				},
				Text
				{
					font = TwoLineButtonFont,
					name="newplayerbutton_label",
					label="player",
					x=0,
					y=18,
					w=kMax,
					h=25,
					flags = kHAlignCenter + kVAlignTop
				},
			};
		},
		
		TriclopsButton
		{
			x=113,
			y=410,
			Button{
				font = NormalButtonFont,
				graphics = NormalButtonGraphics,
				name="delete",
				label="",
				type = kPush,
				scale=0.45,
				Text
				{
					font = TwoLineButtonFont,
					name="deletebutton_label",
					label="delete",
					x=0,
					y=6,
					w=kMax,
					h=25,
					flags = kHAlignCenter + kVAlignTop
				},
				Text
				{
					font = TwoLineButtonFont,
					name="deleteplayerbutton_label",
					label="player",
					x=0,
					y=18,
					w=kMax,
					h=25,
					flags = kHAlignCenter + kVAlignTop
				},
			};
		}
	}
}



