// This program is exactly the same as the specular-only VP.
void parallaxBackground_vp(
                                	float4 position 	: POSITION,
			                float2 uv1		: TEXCOORD0,

			                out float4 oPosition    : POSITION,
			                out float2 oUv1		: TEXCOORD0,
			                uniform float4 viewportSize,
			                uniform float4 texSize )
{
	oPosition = position;
	oPosition.z = 1.f;
	oUv1 = uv1;
	//oUv1.x = -oUv1.x;
	float texWidth = texSize.x / texSize.y;
	float viewportWidth = viewportSize.x / viewportSize.y;
	oUv1.x -= ( ( oUv1.x - 0.5f ) * 2.f ) * ( ( texWidth - viewportWidth ) / 4.f ); 
}

void parallaxBackground4_fp(
			     		float2 uv1		: TEXCOORD0,
			     		out float4 color	: COLOR0,
			     		
			     		uniform float4 camPos,
			     		uniform float4 scrollFactorFirstSecond,
			     		uniform float4 scrollFactorThirdFourth,
			     		uniform float4 firstSecondScale,
			     		uniform float4 thirdFourthScale,
			     		
					uniform sampler2D first : register(s0),
					uniform sampler2D second : register(s1),
					uniform sampler2D third : register(s2),
					uniform sampler2D fourth : register(s3) )
{
	float4 fourthCol = tex2D( first, ( uv1 * firstSecondScale.xy ) + camPos.xy * scrollFactorFirstSecond.xy );
	float4 thirdCol = tex2D( second, ( uv1 * firstSecondScale.zw ) + camPos.xy * scrollFactorFirstSecond.zw );
	float4 secondCol = tex2D( third, ( uv1 * thirdFourthScale.xy ) + camPos.xy * scrollFactorThirdFourth.xy );
	float4 firstCol = tex2D( fourth, ( uv1 * thirdFourthScale.zw ) + camPos.xy * scrollFactorThirdFourth.zw );
	float accum = firstCol.w;
	color = firstCol * firstCol.w;
	if( accum < 1.f )
	{
		color += secondCol * min( secondCol.w, 1.f - accum );
		accum += secondCol.w;
		if( accum < 1.f )
		{
			color += thirdCol * min( thirdCol.w, 1.f - accum );
			accum += thirdCol.w;
			if( accum < 1.f )
			{
				color += fourthCol * min( fourthCol.w, 1.f - accum );
			
			}
		}
	}
	//color = float4( 1.f, 1.f, 1.f, 1.f );
}

void parallaxBackground4Factor_fp(
			     		float2 uv1		: TEXCOORD0,
			     		out float4 color	: COLOR0,
			     		
			     		uniform float4 camPos,
			     		uniform float4 scrollFactorFirstSecond,
			     		uniform float4 scrollFactorThirdFourth,
			     		uniform float4 firstSecondScale,
			     		uniform float4 thirdFourthScale,
			     		
					uniform sampler2D first : register(s0),
					uniform sampler2D second : register(s1),
					uniform sampler2D third : register(s2),
					uniform sampler2D fourth : register(s3),
					uniform float factor )
{
	float4 fourthCol = tex2D( first, ( uv1 * firstSecondScale.xy ) + camPos.xy * scrollFactorFirstSecond.xy );
	float4 thirdCol = tex2D( second, ( uv1 * firstSecondScale.zw ) + camPos.xy * scrollFactorFirstSecond.zw );
	float4 secondCol = tex2D( third, ( uv1 * thirdFourthScale.xy ) + camPos.xy * scrollFactorThirdFourth.xy );
	float4 firstCol = tex2D( fourth, ( uv1 * thirdFourthScale.zw ) + camPos.xy * scrollFactorThirdFourth.zw );
	float accum = firstCol.w;
	color = firstCol * firstCol.w;
	if( accum < 1.f )
	{
		color += secondCol * min( secondCol.w, 1.f - accum );
		accum += secondCol.w;
		if( accum < 1.f )
		{
			color += thirdCol * min( thirdCol.w, 1.f - accum );
			accum += thirdCol.w;
			if( accum < 1.f )
			{
				color += fourthCol * min( fourthCol.w, 1.f - accum );
			
			}
		}
	}
	color *= factor;
}