//----------------------------------------------------------------------------
// hdrPostFX_vp vertex program
//----------------------------------------------------------------------------
void hdrPostFX_vp(float4   position  : POSITION,
                  float2   texCoord  : TEXCOORD0,
              out float2   oTexCoord : TEXCOORD0,
              out float4   oPosition : POSITION)
{
    // The position has allready been transformed to clip space
    oPosition = position;
    oPosition.z = 1.0f;

    oTexCoord = texCoord;
}

//----------------------------------------------------------------------------
// downsample4x4_fp fragment program
//----------------------------------------------------------------------------
float4 downsample_fp(float2    texCoord : TEXCOORD0,
             uniform sampler2D tex      : register(s0)) : COLOR
{
    // Texture filtering will automatically interpolate the colour for us
    return tex2D(tex, texCoord);
}

//----------------------------------------------------------------------------
// brightpass_fp fragment program
//----------------------------------------------------------------------------
float4 brightpass_fp(float2    texCoord : TEXCOORD0,
             uniform float     threshold,
             uniform sampler2D tex      : register(s0)) : COLOR
{
    float4 average = tex2D(tex, texCoord);
    float luminance = max(average.r, max(average.g, average.b));

    if (luminance < threshold)
        average = float4(0.0f, 0.0f, 0.0f, 1.0f);

    return average;
}

//----------------------------------------------------------------------------
// gaussianblur_fp fragment program
//---------------------------------------------------------------------------
// Sigma = 6.0
static const float kernel[19] = { 0.0215863f, 0.027335f, 0.0336664f,
    0.0403285f, 0.0469853f, 0.0532413f, 0.0586776f, 0.0628972f, 0.0655733f,
    0.0664904f, 0.0655733f, 0.0628972f, 0.0586776f, 0.0532413f, 0.0469853f,
    0.0403285f, 0.0336664f, 0.027335f, 0.0215863 };

float4 gaussianblur_fp(float2    texCoord : TEXCOORD0,
               uniform float2    direction,
               uniform float4    texelSize,
               uniform sampler2D tex      : register(s0)) : COLOR
{
    float4 colour = float4(0.0f, 0.0f, 0.0f, 0.0f);
    float2 step = direction * texelSize.xy;
    
    colour += tex2D(tex, texCoord + step * -9.0f) * kernel[0];
    colour += tex2D(tex, texCoord + step * -8.0f) * kernel[1];
    colour += tex2D(tex, texCoord + step * -7.0f) * kernel[2];
    colour += tex2D(tex, texCoord + step * -6.0f) * kernel[3];
    colour += tex2D(tex, texCoord + step * -5.0f) * kernel[4];
    colour += tex2D(tex, texCoord + step * -4.0f) * kernel[5];
    colour += tex2D(tex, texCoord + step * -3.0f) * kernel[6];
    colour += tex2D(tex, texCoord + step * -2.0f) * kernel[7];
    colour += tex2D(tex, texCoord + step * -1.0f) * kernel[8];
    colour += tex2D(tex, texCoord) * kernel[9];
    colour += tex2D(tex, texCoord + step) * kernel[10];
    colour += tex2D(tex, texCoord + step * 2.0f) * kernel[11];
    colour += tex2D(tex, texCoord + step * 3.0f) * kernel[12];
    colour += tex2D(tex, texCoord + step * 4.0f) * kernel[13];
    colour += tex2D(tex, texCoord + step * 5.0f) * kernel[14];
    colour += tex2D(tex, texCoord + step * 6.0f) * kernel[15];
    colour += tex2D(tex, texCoord + step * 7.0f) * kernel[16];
    colour += tex2D(tex, texCoord + step * 8.0f) * kernel[17];
    colour += tex2D(tex, texCoord + step * 9.0f) * kernel[18];

    colour.a = 1.0f;
    return colour;
}

//----------------------------------------------------------------------------
// tonemap fragment program
//----------------------------------------------------------------------------
float4 tonemapping_fp(float2    texCoord     : TEXCOORD0,
              uniform float     blurAmount,
              uniform sampler2D sceneTexture : register(s0),
              uniform sampler2D blurTexture  : register(s1)) : COLOR
{
    float4 scene = tex2D(sceneTexture, texCoord);
    float4 blur = tex2D(blurTexture, texCoord);

    float4 colour = scene + blur * blurAmount;

    colour.a = 1.0f;
    return colour;
}