
// Expand a range-compressed vector (used with normal maps)
float3 expand(float3 v)
{
	return v * 2 - 1;
}
float3 compress(float3 v)
{
	return ( v + 1 ) / 2;
}
float3 decodeNormal(float2 enc)
{
	float2 fenc = enc * 2 - 1;
	float3 n = float3( 0.f, 0.f, -( dot( fenc, fenc ) * 2 - 1 ) );
	n.xy = normalize( fenc ) * sqrt( 1 - n.z * n.z );
	return n;
}

void directionalAmbient_vp(
                                	float4 position : POSITION,
                                	float3 corner  : NORMAL,
                                	out float3 oFirstDirLightPos : TEXCOORD2,
                                	out float3 oSecondDirLightPos : TEXCOORD3,
			                float2 uv1	: TEXCOORD0,
			                out float4 oPosition    : POSITION,
			                out float3 oCorner      : TEXCOORD1,
			                out float2 oUv1		: TEXCOORD0,
			                uniform float4x4 view,
			                uniform float3 firstDirLightPos,
			                uniform float3 secondDirLightPos )
{
	oPosition = position;
	oPosition.z = 1.f;
	//oPosition.w = 1.f;
	oUv1 = uv1;
	oCorner = corner;
	oFirstDirLightPos = mul( (float3x3)view, firstDirLightPos );
	oFirstDirLightPos = normalize( oFirstDirLightPos );
	oSecondDirLightPos = mul( (float3x3)view, secondDirLightPos );
	oSecondDirLightPos = normalize( oSecondDirLightPos );
}

void directionalAmbient_fp(
				float2 uv1 : TEXCOORD0,
				float3 corner  : TEXCOORD1,
				out float4 color : COLOR0,
				
				//uniform sampler2D normalMap : register(s0),
				uniform sampler2D normalAndDepthMap : register(s0),
				uniform sampler2D diffuseMap : register(s1),
				uniform sampler2D specularCol : register(s2),

				float3 firstDirLightPos : TEXCOORD2,
				uniform float3 firstDirLightFrontColor,
				uniform float3 firstDirLightBackColor,

				float3 secondDirLightPos : TEXCOORD3,
				uniform float3 secondDirLightColor )
{
	color.w = 0.f;
	//float3 normal = decodeNormal( tex2D( normalMap, uv1 ).xy );
	float3 normal = decodeNormal( tex2D( normalAndDepthMap, uv1 ).zw );
	float4 diffMap = tex2D( diffuseMap, uv1 );
	float4 specMap = tex2D( specularCol, uv1 );
	
	float3 viewVec = -normalize( corner );
	
	float3 halfAngle = ( viewVec + firstDirLightPos ) / 2;
	float diffFactor = dot( firstDirLightPos, normal );
	float diffFactorSat = max( 0, diffFactor );
	float specExp = specMap.w * 256;
	
	float specFactor = pow( max( 0, dot( halfAngle, normal ) ), specExp );
	
	color.xyz = ( firstDirLightFrontColor * diffMap.xyz * diffFactorSat ) + ( specMap.xyz * specFactor );
	diffFactorSat = max( 0, -diffFactor );
	//halfAngle = ( viewVec + -firstDirLightPos ) / 2;
	halfAngle = normalize( viewVec + -firstDirLightPos );
	specFactor = pow( max( 0, dot( halfAngle, normal ) ), specExp );
	color.xyz += ( firstDirLightBackColor * diffMap.xyz * diffFactorSat ) + ( specMap.xyz * specFactor );
	
	diffFactorSat = max( 0, dot( secondDirLightPos, normal ) );
	//halfAngle = ( viewVec + secondDirLightPos ) / 2;
	halfAngle = normalize( viewVec + secondDirLightPos );
	specFactor = pow( max( 0, dot( halfAngle, normal ) ), specExp );
	color.xyz += ( secondDirLightColor * diffMap.xyz * diffFactorSat ) + ( specMap.xyz * specFactor );
	
	
	
	/*float4 tmp = mul( projection, float4( corner, 1.f ) );
	tmp.xyz /= tmp.w;
	tmp.y = -tmp.y;
	tmp.xy += 1.f;
	tmp.xy *= 0.5f;
	color.xyz = length( tmp.xy - uv1 ) * 1000.f;*/
}
